/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import com.vaadin.data.Property;
import com.vaadin.server.Page;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.Button;
import com.vaadin.ui.Table;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.opennms.features.topology.api.support.DialogWindow;
import org.opennms.features.topology.api.support.InfoWindow;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmIdColumnLinkGenerator
implements Table.ColumnGenerator {
    private static final long serialVersionUID = 621311104480258016L;
    private static final Logger LOG = LoggerFactory.getLogger(AlarmIdColumnLinkGenerator.class);
    private final String alarmIdPropertyName;
    private final AlarmDao alarmDao;

    public AlarmIdColumnLinkGenerator(AlarmDao alarmDao, String alarmIdPropertyName) {
        this.alarmIdPropertyName = alarmIdPropertyName;
        this.alarmDao = alarmDao;
    }

    public Object generateCell(final Table source, Object itemId, Object columnId) {
        if (source == null) {
            return null;
        }
        Property alarmIdProperty = source.getContainerProperty(itemId, (Object)this.alarmIdPropertyName);
        final Integer alarmId = (Integer)alarmIdProperty.getValue();
        if (alarmId == null) {
            return null;
        }
        Button button = new Button("" + alarmId);
        button.setStyleName("link");
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 3698209256202413810L;

            public void buttonClick(Button.ClickEvent event) {
                OnmsAlarm alarm = (OnmsAlarm)AlarmIdColumnLinkGenerator.this.alarmDao.get((Serializable)alarmId);
                if (alarm == null) {
                    new DialogWindow(source.getUI(), "Alarm does not exist!", "The alarm information cannot be shown. \nThe alarm does not exist anymore. \n\nPlease refresh the Alarm Table.");
                    return;
                }
                URI currentLocation = Page.getCurrent().getLocation();
                String contextRoot = VaadinServlet.getCurrent().getServletContext().getContextPath();
                String redirectFragment = contextRoot + "/alarm/detail.htm?quiet=true&id=" + alarmId;
                LOG.debug("alarm {} clicked, current location = {}, uri = {}", new Object[]{alarmId, currentLocation, redirectFragment});
                try {
                    source.getUI().addWindow((Window)new InfoWindow(new URL(currentLocation.toURL(), redirectFragment), new InfoWindow.LabelCreator(){

                        public String getLabel() {
                            return "Alarm Info " + alarmId;
                        }
                    }));
                }
                catch (MalformedURLException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        return button;
    }
}

