/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.features.topology.api.AbstractCheckedOperation;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.Operation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.api.topo.VertexRef;

public class NCSStatusToggleOperation
extends AbstractCheckedOperation {
    private EdgeStatusProvider m_ncsEdgeStatusProvider;

    public void applyHistory(GraphContainer container, Map<String, String> settings) {
        Set edgeStatusProviders = container.getEdgeStatusProviders();
        String historyValue = settings.get(((Object)((Object)this)).getClass().getName());
        boolean statusEnabled = Boolean.TRUE.toString().equals(historyValue);
        if (statusEnabled) {
            if (!edgeStatusProviders.contains(this.m_ncsEdgeStatusProvider)) {
                edgeStatusProviders.add(this.m_ncsEdgeStatusProvider);
            }
        } else if (edgeStatusProviders.contains(this.m_ncsEdgeStatusProvider)) {
            edgeStatusProviders.remove(this.m_ncsEdgeStatusProvider);
        }
    }

    public Operation.Undoer execute(List<VertexRef> targets, OperationContext operationContext) {
        this.toggle(operationContext.getGraphContainer());
        return new Operation.Undoer(){

            public void undo(OperationContext operationContext) {
                NCSStatusToggleOperation.this.toggle(operationContext.getGraphContainer());
            }
        };
    }

    private void toggle(GraphContainer graphContainer) {
        if (graphContainer.getEdgeStatusProviders().contains(this.m_ncsEdgeStatusProvider)) {
            graphContainer.getEdgeStatusProviders().remove(this.m_ncsEdgeStatusProvider);
        } else {
            graphContainer.getEdgeStatusProviders().add(this.m_ncsEdgeStatusProvider);
        }
        graphContainer.redoLayout();
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        return true;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected boolean isChecked(GraphContainer container) {
        Set edgeStatusProviders = container.getEdgeStatusProviders();
        return edgeStatusProviders.contains(this.m_ncsEdgeStatusProvider);
    }

    public EdgeStatusProvider getNcsEdgeStatusProvider() {
        return this.m_ncsEdgeStatusProvider;
    }

    public void setNcsEdgeStatusProvider(EdgeStatusProvider ncsEdgeStatusProvider) {
        this.m_ncsEdgeStatusProvider = ncsEdgeStatusProvider;
    }
}

