/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.devutils.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXB;
import org.opennms.features.topology.api.Operation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.WrappedEdge;
import org.opennms.features.topology.api.topo.WrappedGraph;
import org.opennms.features.topology.api.topo.WrappedVertex;

public class SaveToXmlOperation
implements Operation {
    public Operation.Undoer execute(List<VertexRef> targets, OperationContext operationContext) {
        GraphProvider graphProvider = operationContext.getGraphContainer().getBaseTopology();
        HashMap<String, WrappedVertex> idMap = new HashMap<String, WrappedVertex>();
        ArrayList<WrappedVertex> vertices = new ArrayList<WrappedVertex>();
        for (Object vertex : graphProvider.getVertices(new Criteria[0])) {
            WrappedVertex wrappedVertex = WrappedVertex.create((Vertex)vertex);
            vertices.add(wrappedVertex);
            idMap.put(vertex.getId(), wrappedVertex);
        }
        for (Object vertex : graphProvider.getVertices(new Criteria[0])) {
            WrappedVertex wrappedParent;
            Vertex parent = graphProvider.getParent((VertexRef)vertex);
            if (parent == null) continue;
            WrappedVertex wrappedVertex = (WrappedVertex)idMap.get(vertex.getId());
            wrappedVertex.parent = wrappedParent = (WrappedVertex)idMap.get(parent.getId());
        }
        ArrayList<WrappedEdge> edges = new ArrayList<WrappedEdge>();
        for (Edge edge : graphProvider.getEdges(new Criteria[0])) {
            WrappedVertex wrappedSource = (WrappedVertex)idMap.get(edge.getSource().getVertex().getId());
            WrappedVertex wrappedTarget = (WrappedVertex)idMap.get(edge.getTarget().getVertex().getId());
            edges.add(new WrappedEdge(edge, wrappedSource, wrappedTarget));
        }
        WrappedGraph graph = new WrappedGraph(graphProvider.getVertexNamespace(), vertices, edges);
        JAXB.marshal((Object)graph, (File)new File("/tmp/saved-graph.xml"));
        return null;
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        return true;
    }

    public boolean enabled(List<VertexRef> targets, OperationContext operationContext) {
        return true;
    }

    public String getId() {
        return "SaveToXML";
    }
}

