/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import com.vaadin.data.Container;
import com.vaadin.ui.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opennms.features.topology.api.SelectionNotifier;
import org.opennms.features.topology.api.VerticesUpdateManager;
import org.opennms.features.topology.plugins.browsers.OnmsDaoContainer;
import org.opennms.osgi.EventConsumer;
import org.opennms.osgi.EventProxy;
import org.opennms.osgi.EventProxyAware;

public class SelectionAwareTable
extends Table
implements VerticesUpdateManager.VerticesUpdateListener,
EventProxyAware {
    private static final long serialVersionUID = 2761774077365441249L;
    private final OnmsDaoContainer<?, ? extends Serializable> m_container;
    private final Set<SelectionNotifier> m_selectionNotifiers = new CopyOnWriteArraySet<SelectionNotifier>();
    private List<String> nonCollapsibleColumns = new ArrayList<String>();
    private EventProxy eventProxy;
    private boolean m_disableRowCacheRefresh = false;

    public SelectionAwareTable(String caption, OnmsDaoContainer container) {
        super(caption, (Container)container);
        this.m_container = container;
    }

    public void setColumnGenerators(Map generators) {
        for (Object key : generators.keySet()) {
            super.addGeneratedColumn(key, (Table.ColumnGenerator)generators.get(key));
            try {
                this.m_selectionNotifiers.add((SelectionNotifier)generators.get(key));
            }
            catch (ClassCastException classCastException) {}
        }
    }

    public void setCellStyleGenerator(Table.CellStyleGenerator generator) {
        super.setCellStyleGenerator(generator);
    }

    public String toString() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setNonCollapsibleColumns(List<String> nonCollapsibleColumns) {
        this.m_disableRowCacheRefresh = true;
        try {
            for (Object obj : this.m_container.getContainerPropertyIds()) {
                this.setColumnCollapsible(obj, true);
            }
            if (nonCollapsibleColumns == null) {
                nonCollapsibleColumns = new ArrayList<String>();
            }
            for (Object object : nonCollapsibleColumns) {
                this.setColumnCollapsible(object, false);
            }
        }
        finally {
            this.m_disableRowCacheRefresh = false;
        }
        this.refreshRowCache();
    }

    public void refreshRowCache() {
        if (this.m_disableRowCacheRefresh) {
            return;
        }
        super.refreshRowCache();
    }

    @EventConsumer
    public void verticesUpdated(VerticesUpdateManager.VerticesUpdateEvent event) {
        this.m_container.verticesUpdated(event);
    }

    public void resetPageBuffer() {
        if (this.m_container != null && this.m_container.getCache() != null && this.m_container.getPage() != null) {
            this.m_container.getCache().reload(this.m_container.getPage());
        }
        super.resetPageBuffer();
    }

    public void setEventProxy(EventProxy eventProxy) {
        this.eventProxy = eventProxy;
        for (Object eachPropertyId : this.getContainerPropertyIds()) {
            Table.ColumnGenerator columnGenerator = this.getColumnGenerator(eachPropertyId);
            if (columnGenerator == null || !EventProxyAware.class.isAssignableFrom(columnGenerator.getClass())) continue;
            ((EventProxyAware)columnGenerator).setEventProxy(eventProxy);
        }
    }

    protected EventProxy getEventProxy() {
        if (this.eventProxy != null) {
            return this.eventProxy;
        }
        throw new IllegalArgumentException("EventProxy should not be null!");
    }
}

