/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import java.util.HashMap;
import java.util.Map;

public class Profiler {
    protected final Map<String, Timer> timerMap = new HashMap<String, Timer>();

    public void start(String key) {
        if (this.timerMap.get(key) == null) {
            this.timerMap.put(key, new Timer());
        }
        this.timerMap.get(key).start();
    }

    public void stop(String key) {
        this.timerMap.get(key).stop();
    }

    public String toString() {
        String HEADER = "%-60s%10s%20s%20s%n";
        String ROW = "%-60s%10d%20.2f%20.2f%n";
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-60s%10s%20s%20s%n", "key", "count", "avg (ms)", "sum (sec)"));
        for (String eachKey : this.timerMap.keySet()) {
            sb.append(String.format("%-60s%10d%20.2f%20.2f%n", eachKey, this.timerMap.get(eachKey).getCount(), this.timerMap.get(eachKey).getAVG(), this.toSeconds(this.timerMap.get(eachKey).getSum())));
        }
        return sb.toString();
    }

    private double toSeconds(double sum) {
        return sum / 1000.0;
    }

    public static class Timer {
        long startTime;
        long endTime;
        int count;
        int sum;

        public synchronized void start() {
            if (!this.isStarted()) {
                this.startTime = System.currentTimeMillis();
            }
            ++this.count;
        }

        public synchronized void stop() {
            this.endTime = System.currentTimeMillis();
            this.sum = (int)((long)this.sum + (this.endTime - this.startTime));
            this.startTime = 0L;
            this.endTime = 0L;
        }

        public synchronized boolean isStarted() {
            return this.startTime > 0L;
        }

        public synchronized long getSum() {
            return this.sum;
        }

        public synchronized int getCount() {
            return this.count;
        }

        public synchronized double getAVG() {
            return (double)this.getSum() / (double)this.count;
        }
    }
}

