/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import com.vaadin.data.Property;
import com.vaadin.ui.Button;
import com.vaadin.ui.Table;
import java.util.Collection;
import java.util.HashSet;
import org.opennms.features.topology.api.SelectionListener;
import org.opennms.features.topology.api.VerticesUpdateManager;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.plugins.browsers.ToStringColumnGenerator;
import org.opennms.osgi.EventProxy;
import org.opennms.osgi.EventProxyAware;

public class NodeSelectionLinkGenerator
implements Table.ColumnGenerator,
EventProxyAware {
    private static final long serialVersionUID = -1072007643387089006L;
    private final String m_nodeIdProperty;
    private final String m_nodeLabelProperty;
    private final Table.ColumnGenerator m_generator;
    private Collection<SelectionListener> m_selectionListeners = new HashSet<SelectionListener>();
    private EventProxy m_eventProxy;

    public NodeSelectionLinkGenerator(String nodeIdProperty, String nodeLabelProperty) {
        this(nodeIdProperty, nodeLabelProperty, new ToStringColumnGenerator());
    }

    private NodeSelectionLinkGenerator(String nodeIdProperty, String nodeLabelProperty, Table.ColumnGenerator generator) {
        this.m_nodeIdProperty = nodeIdProperty;
        this.m_nodeLabelProperty = nodeLabelProperty;
        this.m_generator = generator;
    }

    public Object generateCell(final Table source, final Object itemId, Object columnId) {
        final Property nodeIdProperty = source.getContainerProperty(itemId, (Object)this.m_nodeIdProperty);
        Object cellValue = this.m_generator.generateCell(source, itemId, columnId);
        if (cellValue == null) {
            return null;
        }
        if (nodeIdProperty.getValue() == null) {
            return cellValue;
        }
        Button button = new Button(cellValue.toString());
        button.setStyleName("link");
        button.setDescription(((Integer)nodeIdProperty.getValue()).toString());
        button.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                Integer nodeId = (Integer)nodeIdProperty.getValue();
                String nodeLabel = (String)source.getContainerProperty(itemId, (Object)NodeSelectionLinkGenerator.this.m_nodeLabelProperty).getValue();
                NodeSelectionLinkGenerator.this.fireVertexUpdatedEvent(nodeId, nodeLabel);
            }
        });
        return button;
    }

    protected void fireVertexUpdatedEvent(Integer nodeId, String nodeLabel) {
        HashSet<DefaultVertexRef> vertexRefs = new HashSet<DefaultVertexRef>();
        DefaultVertexRef vRef = new DefaultVertexRef("nodes", String.valueOf(nodeId), nodeLabel);
        vertexRefs.add(vRef);
        this.getEventProxy().fireEvent((Object)new VerticesUpdateManager.VerticesUpdateEvent(vertexRefs));
    }

    public void setEventProxy(EventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }

    public EventProxy getEventProxy() {
        return this.m_eventProxy;
    }
}

