/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.features.topology.api.VerticesUpdateManager;
import org.opennms.features.topology.plugins.browsers.OnmsDaoContainer;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.osgi.EventConsumer;

public class AlarmDaoContainer
extends OnmsDaoContainer<OnmsAlarm, Integer> {
    private static final long serialVersionUID = -4026870931086916312L;

    public AlarmDaoContainer(AlarmDao dao) {
        super(OnmsAlarm.class, dao);
        this.addBeanToHibernatePropertyMapping("nodeLabel", "node.label");
    }

    @Override
    protected void updateContainerPropertyIds(Map<Object, Class<?>> properties) {
        properties.remove("details");
        properties.remove("distPoller");
    }

    @Override
    protected Integer getId(OnmsAlarm bean) {
        return bean == null ? null : bean.getId();
    }

    @Override
    public Collection<?> getSortableContainerPropertyIds() {
        HashSet propertyIds = new HashSet();
        propertyIds.addAll(this.getContainerPropertyIds());
        propertyIds.remove("selection");
        return Collections.unmodifiableCollection(propertyIds);
    }

    @Override
    protected void addAdditionalCriteriaOptions(Criteria criteria, OnmsDaoContainer.Page page, boolean doOrder) {
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
    }

    @EventConsumer
    public void verticesUpdated(VerticesUpdateManager.VerticesUpdateEvent event) {
        ArrayList<Restriction> newRestrictions = new ArrayList<Restriction>();
        List<Integer> nodeIds = this.extractNodeIds(event.getVertexRefs());
        if (nodeIds.size() > 0) {
            newRestrictions.add((Restriction)Restrictions.in((String)"node.id", nodeIds));
        }
        if (!this.getRestrictions().equals(newRestrictions)) {
            this.setRestrictions(newRestrictions);
            this.getCache().reload(this.getPage());
            this.fireItemSetChangedEvent();
        }
    }
}

