/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import java.util.Arrays;
import java.util.List;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.features.topology.api.VerticesUpdateManager;
import org.opennms.features.topology.plugins.browsers.NodeIdFocusToRestrictionsConverter;
import org.opennms.features.topology.plugins.browsers.OnmsDaoContainer;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.osgi.EventConsumer;

public class NodeDaoContainer
extends OnmsDaoContainer<OnmsNode, Integer> {
    private static final long serialVersionUID = -5697472655705494537L;

    public NodeDaoContainer(NodeDao dao) {
        super(OnmsNode.class, dao);
        this.addBeanToHibernatePropertyMapping("primaryInterface", "ipInterfaces.ipAddress");
    }

    @Override
    protected Integer getId(OnmsNode bean) {
        return bean == null ? null : bean.getId();
    }

    @Override
    protected void addAdditionalCriteriaOptions(Criteria criteria, OnmsDaoContainer.Page page, boolean doOrder) {
        if (!doOrder) {
            return;
        }
        criteria.setAliases(Arrays.asList(new Alias("ipInterfaces", "ipInterfaces", Alias.JoinType.LEFT_JOIN, (Restriction)new EqRestriction("ipInterfaces.isSnmpPrimary", (Object)PrimaryType.PRIMARY))));
    }

    @Override
    protected void doItemAddedCallBack(int rowNumber, Integer id, OnmsNode eachBean) {
        eachBean.getPrimaryInterface();
    }

    @EventConsumer
    public void verticesUpdated(VerticesUpdateManager.VerticesUpdateEvent event) {
        NodeIdFocusToRestrictionsConverter converter = new NodeIdFocusToRestrictionsConverter(){

            @Override
            protected Restriction createRestriction(Integer nodeId) {
                return new EqRestriction("id", (Object)nodeId);
            }
        };
        List<Restriction> newRestrictions = converter.getRestrictions(event.getVertexRefs());
        if (!this.getRestrictions().equals(newRestrictions)) {
            this.setRestrictions(newRestrictions);
            this.getCache().reload(this.getPage());
            this.fireItemSetChangedEvent();
        }
    }
}

