/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.BeanItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.Order;
import org.opennms.features.topology.api.SelectionContext;
import org.opennms.features.topology.api.SelectionListener;
import org.opennms.features.topology.api.SelectionNotifier;
import org.opennms.netmgt.dao.OnmsDao;

public abstract class OnmsDaoContainer<T, K extends Serializable>
implements SelectionNotifier,
SelectionListener,
Container,
Container.Sortable,
Container.Ordered,
Container.ItemSetChangeNotifier {
    private static final long serialVersionUID = -9131723065433979979L;
    private final OnmsDao<T, K> m_dao;
    protected Criteria m_criteria = new Criteria(this.getItemClass());
    private final Collection<Container.ItemSetChangeListener> m_itemSetChangeListeners = new HashSet<Container.ItemSetChangeListener>();
    private Collection<SelectionListener> m_selectionListeners = new HashSet<SelectionListener>();

    public OnmsDaoContainer(OnmsDao<T, K> dao) {
        this.m_dao = dao;
    }

    public final boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add new properties to objects in this container");
    }

    public Object addItem() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add new items to this container");
    }

    public Item addItem(Object itemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add new items to this container");
    }

    public boolean containsId(Object itemId) {
        if (itemId == null) {
            return false;
        }
        return this.m_dao.get((Serializable)itemId) != null;
    }

    public Property getContainerProperty(Object itemId, Object propertyId) {
        Item item = this.getItem(itemId);
        return item.getItemProperty(propertyId);
    }

    public abstract Collection<?> getContainerPropertyIds();

    public Item getItem(Object itemId) {
        if (itemId == null) {
            return null;
        }
        Object bean = this.m_dao.get((Serializable)itemId);
        return new BeanItem(bean);
    }

    public Collection<?> getItemIds() {
        List beans = this.m_dao.findMatching(this.m_criteria);
        ArrayList<K> retval = new ArrayList<K>();
        for (Object bean : beans) {
            retval.add(this.getId(bean));
        }
        return retval;
    }

    protected abstract K getId(T var1);

    public abstract Class<T> getItemClass();

    public abstract Class<?> getType(Object var1);

    public boolean removeAllItems() throws UnsupportedOperationException {
        this.m_dao.clear();
        return true;
    }

    public final boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove properties from objects in this container");
    }

    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        this.m_dao.delete((Serializable)itemId);
        return true;
    }

    public int size() {
        return this.m_dao.countMatching(this.m_criteria);
    }

    public Object addItemAfter(Object previousItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add new items to this container");
    }

    public Item addItemAfter(Object previousItemId, Object newItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add new items to this container");
    }

    public Object firstItemId() {
        Iterator itr = this.m_dao.findMatching(this.m_criteria).iterator();
        if (itr.hasNext()) {
            return this.getId(itr.next());
        }
        return null;
    }

    public boolean isFirstId(Object itemId) {
        Object firstItemId = this.firstItemId();
        if (firstItemId == null) {
            return false;
        }
        return firstItemId.equals(itemId);
    }

    public boolean isLastId(Object itemId) {
        Object lastItemId = this.lastItemId();
        if (lastItemId == null) {
            return itemId == null;
        }
        if (itemId == null) {
            return false;
        }
        return lastItemId.equals(itemId);
    }

    public Object lastItemId() {
        List all = this.m_dao.findMatching(this.m_criteria);
        if (all.size() > 0) {
            return this.getId(all.get(all.size() - 1));
        }
        return null;
    }

    public Object nextItemId(Object itemId) {
        if (itemId == null) {
            return null;
        }
        Iterator itr = this.m_dao.findMatching(this.m_criteria).iterator();
        do {
            if (!itemId.equals(this.getId(itr.next()))) continue;
            if (itr.hasNext()) {
                return this.getId(itr.next());
            }
            return null;
        } while (itr.hasNext());
        return null;
    }

    public Object prevItemId(Object itemId) {
        if (itemId == null) {
            return null;
        }
        Iterator itr = this.m_dao.findMatching(this.m_criteria).iterator();
        Object previous = null;
        do {
            Object current;
            if (itemId.equals(this.getId(current = itr.next()))) {
                return previous;
            }
            previous = current;
        } while (itr.hasNext());
        return null;
    }

    public Collection<?> getSortableContainerPropertyIds() {
        return this.getContainerPropertyIds();
    }

    public void sort(Object[] propertyId, boolean[] ascending) {
        if (propertyId.length > ascending.length) {
            throw new IllegalArgumentException("Property list and ascending list are different sizes");
        }
        ArrayList<Order> orders = new ArrayList<Order>();
        for (int i = 0; i < propertyId.length; ++i) {
            if (ascending[i]) {
                orders.add(Order.asc((String)((String)propertyId[i])));
                continue;
            }
            orders.add(Order.desc((String)((String)propertyId[i])));
        }
        this.m_criteria.setOrders(orders);
    }

    public abstract void selectionChanged(SelectionContext var1);

    public void addListener(Container.ItemSetChangeListener listener) {
        this.m_itemSetChangeListeners.add(listener);
    }

    public void removeListener(Container.ItemSetChangeListener listener) {
        this.m_itemSetChangeListeners.remove(listener);
    }

    protected void fireItemSetChangedEvent() {
        Container.ItemSetChangeEvent event = new Container.ItemSetChangeEvent(){
            private static final long serialVersionUID = -2796401359570611938L;

            public Container getContainer() {
                return OnmsDaoContainer.this;
            }
        };
        for (Container.ItemSetChangeListener listener : this.m_itemSetChangeListeners) {
            listener.containerItemSetChange(event);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.m_selectionListeners.add(listener);
    }

    public void setSelectionListeners(Set<SelectionListener> listeners) {
        this.m_selectionListeners = listeners;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.m_selectionListeners.remove(listener);
    }
}

