/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.shell;

import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.topology.api.HistoryManager;
import org.opennms.features.topology.api.support.SavedHistory;

@Command(scope="opennms-topo", name="show-history", description="Shows the history of a certain user")
@Service
public class ShowHistoryCommand
implements Action {
    @Argument(required=false, name="user", description="The user to show the history for.")
    String user = "admin";
    @Reference
    public HistoryManager historyManager;

    public Object execute() throws Exception {
        SavedHistory savedHistory = this.historyManager.getHistoryByUserId(this.user);
        if (savedHistory == null) {
            System.out.println("No History for user '" + this.user + "' found.");
        } else {
            System.out.println("History for user '" + this.user + "':");
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SavedHistory.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)savedHistory, (OutputStream)System.out);
        }
        return null;
    }
}

