/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.shell;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.topology.api.Operation;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@Command(scope="opennms-topo", name="listoperations", description="Lists the available OpenNMS topology operations.")
@Service
public class OperationListShellCommand
implements Action {
    @Reference
    BundleContext bundleContext;

    public Object execute() throws Exception {
        Map props;
        ArrayList operations = Lists.newArrayList();
        HashMap properties = new HashMap();
        Collection services = this.bundleContext.getServiceReferences(Operation.class, null);
        if (services == null) {
            return null;
        }
        for (ServiceReference sr : services) {
            Operation operation = (Operation)this.bundleContext.getService(sr);
            if (operation == null) continue;
            operations.add(operation);
            props = new TreeMap<String, Object>();
            for (String key : sr.getPropertyKeys()) {
                props.put(key, sr.getProperty(key));
            }
            properties.put(operation, props);
        }
        for (Operation operation : operations) {
            String operationClass = operation.getClass().getName();
            System.out.println("    " + OperationListShellCommand.makeLine(operationClass));
            System.out.println("    Class: " + operationClass);
            System.out.println("    ID:    " + operation.getId());
            props = (Map)properties.get(operation);
            if (props.isEmpty()) continue;
            System.out.println("    Service Properties:");
            for (String key : props.keySet()) {
                Object object = props.get(key);
                String value = object instanceof Object[] ? Arrays.toString((Object[])object) : object.toString();
                System.out.println("        " + key + "=" + value);
            }
        }
        return null;
    }

    private static String makeLine(String s) {
        return new String(new char[s.length()]).replace("\u0000", "-");
    }
}

