/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.shell;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.console.commands.NamespaceHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

@Command(scope="onms", name="listnamespaces", description="Lists the available blueprint namespaces and their providers.")
public class BlueprintNamespaceShellCommand
extends OsgiCommandSupport {
    /*
     * Could not resolve type clashes
     */
    protected Object doExecute() throws Exception {
        Collection services = this.bundleContext.getServiceReferences(NamespaceHandler.class, null);
        for (ServiceReference sr : services) {
            Bundle bundle = sr.getBundle();
            Object rawNamespaces = sr.getProperty("osgi.service.blueprint.namespace");
            ArrayList<Object> namespaces = new ArrayList<Object>();
            if (rawNamespaces instanceof String) {
                namespaces.add((String)rawNamespaces);
            } else if (rawNamespaces instanceof Object[]) {
                for (Object namespace : (Object[])rawNamespaces) {
                    namespaces.add(namespace.toString());
                }
            } else if (rawNamespaces instanceof String[]) {
                for (Object namespace : (String[])rawNamespaces) {
                    namespaces.add(namespace);
                }
            } else {
                System.err.println("Hmm, not sure how to interpret: " + rawNamespaces);
            }
            System.out.println(bundle.toString());
            for (Object namespace : namespaces) {
                System.out.println("    " + namespace);
            }
            System.out.println();
        }
        return null;
    }
}

