/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.shell;

import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.features.topology.api.HistoryManager;
import org.opennms.features.topology.api.support.SavedHistory;

@Command(scope="topo", name="show-history", description="Shows the history of a certain user")
public class ShowHistoryCommand
extends OsgiCommandSupport {
    @Argument(required=false, name="user", description="The user to show the history for.")
    String user = "admin";
    private HistoryManager historyManager;

    protected Object doExecute() throws Exception {
        SavedHistory savedHistory = this.historyManager.getHistoryByUserId(this.user);
        if (savedHistory == null) {
            System.out.println("No History for user '" + this.user + "' found.");
        } else {
            System.out.println("History for user '" + this.user + "':");
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SavedHistory.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)savedHistory, (OutputStream)System.out);
        }
        return null;
    }

    public void setHistoryManager(HistoryManager historyManager) {
        this.historyManager = historyManager;
    }
}

