/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal.operations;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.topology.api.AbstractOperation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.netutils.internal.ping.PingWindow;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.icmp.proxy.LocationAwarePingClient;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;

public class PingOperation
extends AbstractOperation {
    private LocationAwarePingClient pingClient;
    private MonitoringLocationDao monitoringLocationDao;
    private NodeDao nodeDao;

    public PingOperation(LocationAwarePingClient pingClient, MonitoringLocationDao monitoringLocationDao, NodeDao nodeDao) {
        this.pingClient = Objects.requireNonNull(pingClient);
        this.monitoringLocationDao = Objects.requireNonNull(monitoringLocationDao);
        this.nodeDao = Objects.requireNonNull(nodeDao);
    }

    public void execute(List<VertexRef> targets, OperationContext operationContext) {
        VertexRef target = targets.get(0);
        Vertex vertex = PingOperation.getVertexItem((OperationContext)operationContext, (VertexRef)target);
        Optional<OnmsNode> node = this.getNodeIfAvailable(vertex);
        List<String> locations = this.monitoringLocationDao.findAll().stream().map(eachLocation -> eachLocation.getLocationName()).collect(Collectors.toList());
        String defaultLocation = node.isPresent() ? node.get().getLocation().getLocationName() : "Default";
        ArrayList ipAddresses = node.isPresent() ? Lists.newArrayList((Iterable)node.get().getIpInterfaces()).stream().map(eachInterface -> eachInterface.getIpAddress()).collect(Collectors.toList()) : Lists.newArrayList((Object[])new InetAddress[]{InetAddressUtils.addr((String)vertex.getIpAddress())});
        InetAddress defaultIp = this.getDefaultIp(vertex, node);
        String caption = String.format("Ping - %s (%s)", vertex.getLabel(), vertex.getIpAddress());
        new PingWindow(this.pingClient, locations, ipAddresses, defaultLocation, defaultIp, caption).open();
    }

    private InetAddress getDefaultIp(Vertex vertex, Optional<OnmsNode> node) {
        if (this.hasValidIpAddress(vertex)) {
            return InetAddressUtils.addr((String)vertex.getIpAddress());
        }
        if (node.isPresent() && node.get().getPrimaryInterface() != null) {
            return node.get().getPrimaryInterface().getIpAddress();
        }
        if (node.isPresent()) {
            return ((OnmsIpInterface)node.get().getIpInterfaces().iterator().next()).getIpAddress();
        }
        throw new IllegalStateException("The vertex does not have a ip address or a node assigned.");
    }

    public boolean enabled(List<VertexRef> targets, OperationContext operationContext) {
        Vertex vertexItem;
        if (targets.size() == 1 && (vertexItem = PingOperation.getVertexItem((OperationContext)operationContext, (VertexRef)targets.get(0))) != null) {
            return this.hasValidIpAddress(vertexItem) || this.hasValidNodeId(vertexItem);
        }
        return false;
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        return targets != null && targets.size() > 0;
    }

    public String getId() {
        return "ping";
    }

    private boolean hasValidNodeId(Vertex vertex) {
        return vertex.getNodeID() != null && this.getNodeIfAvailable(vertex).isPresent();
    }

    private boolean hasValidIpAddress(Vertex vertexItem) {
        String ipAddress = vertexItem.getIpAddress();
        if (!Strings.isNullOrEmpty((String)ipAddress)) {
            try {
                InetAddressUtils.getInetAddress((String)ipAddress);
                return true;
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        }
        return false;
    }

    private Optional<OnmsNode> getNodeIfAvailable(Vertex vertex) {
        Objects.requireNonNull(vertex);
        Objects.requireNonNull(vertex.getNodeID());
        OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)vertex.getNodeID());
        if (node != null && !node.getIpInterfaces().isEmpty()) {
            return Optional.of(node);
        }
        return Optional.empty();
    }
}

