/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.net.URL;
import org.opennms.features.topology.netutils.internal.Node;

public class ResourceGraphsWindow
extends Window {
    private static final double sizePercentage = 0.8;
    private static final int widthCushion = 50;
    private static final int heightCushion = 110;
    private Embedded rgBrowser = null;
    private static final String noLabel = "no such label";

    public ResourceGraphsWindow(Node node, URL nodeURL) {
        this.rgBrowser = new Embedded("", (Resource)new ExternalResource(nodeURL));
        String label = node == null ? "" : node.getLabel();
        label = label == null || label.equals("") || label.equalsIgnoreCase(noLabel) ? "" : " - " + label;
        this.setCaption("Resource Graphs" + label);
        this.setImmediate(true);
        this.setResizable(false);
        VerticalLayout layout = new VerticalLayout();
        layout.addComponent((Component)this.rgBrowser);
        this.setContent((Component)layout);
    }

    public void attach() {
        super.attach();
        int width = this.getUI().getPage().getBrowserWindowWidth();
        int height = this.getUI().getPage().getBrowserWindowHeight();
        int browserWidth = (int)(0.8 * (double)width);
        int browserHeight = (int)(0.8 * (double)height);
        int windowWidth = browserWidth + 50;
        int windowHeight = browserHeight + 110;
        this.setWidth("" + windowWidth + "px");
        this.setHeight("" + windowHeight + "px");
        this.setPositionX((width - windowWidth) / 2);
        this.setPositionY((height - windowHeight) / 2);
        this.rgBrowser.setType(2);
        this.rgBrowser.setWidth("" + browserWidth + "px");
        this.rgBrowser.setHeight("" + browserHeight + "px");
    }
}

