/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal.ping;

import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.opennms.features.topology.netutils.internal.ping.PingForm;
import org.opennms.features.topology.netutils.internal.ping.PingRequest;
import org.opennms.netmgt.icmp.proxy.LocationAwarePingClient;
import org.opennms.netmgt.icmp.proxy.PingStringUtils;
import org.opennms.netmgt.icmp.proxy.PingSummary;

public class PingWindow
extends Window {
    public static final int POLL_INTERVAL = 1000;
    private final ProgressBar progressIndicator;
    private final Button cancelButton;
    private final Button pingButton;
    private final PingForm pingForm;
    private CompletableFuture<PingSummary> pingFuture;

    public PingWindow(LocationAwarePingClient pingClient, List<String> locations, List<InetAddress> ipAddresses, String defaultLocation, InetAddress defaultIp, String caption) {
        Objects.requireNonNull(pingClient);
        Objects.requireNonNull(ipAddresses);
        Objects.requireNonNull(defaultIp);
        Objects.requireNonNull(locations);
        Objects.requireNonNull(defaultLocation);
        Objects.requireNonNull(caption);
        int initialPollInterval = UI.getCurrent().getPollInterval();
        this.pingForm = new PingForm(locations, defaultLocation, ipAddresses, defaultIp);
        TextArea resultArea = new TextArea();
        resultArea.setRows(15);
        resultArea.setSizeFull();
        this.progressIndicator = new ProgressBar();
        this.progressIndicator.setIndeterminate(true);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addClickListener((Button.ClickListener & Serializable)event -> {
            PingWindow.cancel(this.pingFuture);
            resultArea.setValue((String)resultArea.getValue() + "\n" + "Ping cancelled by user");
            this.getUI().setPollInterval(initialPollInterval);
            this.setRunning(false);
        });
        this.pingButton = new Button("Ping");
        this.pingButton.addClickListener((Button.ClickListener & Serializable)event -> {
            try {
                PingRequest pingRequest = this.pingForm.getPingRequest();
                resultArea.setValue("");
                this.setRunning(true);
                this.getUI().setPollInterval(1000);
                this.pingFuture = pingClient.ping(pingRequest.getInetAddress()).withRetries(pingRequest.getRetries()).withPacketSize(pingRequest.getPacketSize()).withTimeout(pingRequest.getTimeout(), TimeUnit.MILLISECONDS).withLocation(pingRequest.getLocation()).withNumberOfRequests(pingRequest.getNumberRequests()).withProgressCallback((newSequence, summary) -> this.getUI().accessSynchronously(() -> {
                    if (this.pingFuture != null && !this.pingFuture.isCancelled()) {
                        this.setRunning(!summary.isComplete());
                        resultArea.setValue(PingStringUtils.renderAll((PingSummary)summary));
                        if (summary.isComplete()) {
                            this.getUI().setPollInterval(initialPollInterval);
                        }
                    }
                })).execute();
            }
            catch (FieldGroup.CommitException e) {
                Notification.show((String)"Validation errors", (String)"Please correct them. Make sure all required fields are set.", (Notification.Type)Notification.Type.ERROR_MESSAGE);
            }
        });
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setSpacing(true);
        buttonLayout.addComponent((Component)this.pingButton);
        buttonLayout.addComponent((Component)this.cancelButton);
        buttonLayout.addComponent((Component)this.progressIndicator);
        VerticalLayout rootLayout = new VerticalLayout();
        rootLayout.setSpacing(true);
        rootLayout.setMargin(true);
        rootLayout.addComponent((Component)this.pingForm);
        rootLayout.addComponent((Component)buttonLayout);
        rootLayout.addComponent((Component)new Label("<b>Results</b>", ContentMode.HTML));
        rootLayout.addComponent((Component)resultArea);
        rootLayout.setExpandRatio((Component)resultArea, 1.0f);
        this.setCaption(caption);
        this.setResizable(false);
        this.setModal(true);
        this.setWidth(800.0f, Sizeable.Unit.PIXELS);
        this.setHeight(600.0f, Sizeable.Unit.PIXELS);
        this.setContent((Component)rootLayout);
        this.center();
        this.setRunning(false);
        this.addCloseListener((Window.CloseListener & Serializable)e -> {
            PingWindow.cancel(this.pingFuture);
            this.getUI().setPollInterval(initialPollInterval);
        });
    }

    private static void cancel(CompletableFuture pingFuture) {
        if (pingFuture != null) {
            pingFuture.cancel(true);
        }
    }

    private void setRunning(boolean running) {
        this.cancelButton.setEnabled(running);
        this.progressIndicator.setVisible(running);
        this.pingButton.setEnabled(!running);
        this.pingForm.setEnabled(!running);
    }

    public void open() {
        UI.getCurrent().addWindow((Window)this);
    }
}

