/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal.service;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.opennms.netmgt.icmp.EchoPacket;

public class PingSequence {
    private boolean timeout;
    private Throwable error;
    private EchoPacket response;
    private int sequenceNumber;

    public PingSequence(EchoPacket response) {
        this.response = response;
        this.sequenceNumber = PingSequence.extractSequenceNumber(this);
    }

    public PingSequence(EchoPacket request, Throwable t) {
        this.error = t;
        this.response = request;
        this.sequenceNumber = PingSequence.extractSequenceNumber(this);
    }

    public PingSequence(EchoPacket request, boolean timeout) {
        this.timeout = timeout;
        this.response = request;
        this.sequenceNumber = PingSequence.extractSequenceNumber(this);
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public boolean isError() {
        return this.error != null;
    }

    public EchoPacket getResponse() {
        return this.response;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isSuccess() {
        return !this.isTimeout() && !this.isError();
    }

    private static int extractSequenceNumber(PingSequence sequence) {
        try {
            return sequence.getResponse().getSequenceNumber();
        }
        catch (NullPointerException nullPointerException) {
            try {
                Field sequenceNumberField;
                Object requestId = sequence.getResponse().getClass().getMethod("getId", new Class[0]).invoke((Object)sequence.getResponse(), new Object[0]);
                if (requestId != null && (sequenceNumberField = requestId.getClass().getDeclaredField("m_sequenceNumber")) != null) {
                    sequenceNumberField.setAccessible(true);
                    Object sequenceNumber = sequenceNumberField.get(requestId);
                    return (Integer)sequenceNumber;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            throw new IllegalArgumentException("Cannot determine sequence number");
        }
    }
}

