/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal.service;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.opennms.features.topology.netutils.internal.service.PingRequest;
import org.opennms.features.topology.netutils.internal.service.PingResult;
import org.opennms.features.topology.netutils.internal.service.PingServiceResponseCallback;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.icmp.PingerFactory;

public class PingService {
    private final ExecutorService executor = Executors.newFixedThreadPool(1);
    private final PingerFactory pingerFactory;
    private Future<Void> currentFuture;

    public PingService(PingerFactory pingerFactory) {
        this.pingerFactory = Objects.requireNonNull(pingerFactory);
    }

    public void cancel() {
        if (this.currentFuture != null) {
            this.currentFuture.cancel(true);
        }
    }

    public void ping(PingRequest pingRequest, Callback uiCallback) {
        Objects.requireNonNull(pingRequest);
        Objects.requireNonNull(uiCallback);
        this.cancel();
        PingServiceResponseCallback callback = new PingServiceResponseCallback(pingRequest, uiCallback);
        this.currentFuture = this.executor.submit(() -> {
            Pinger pinger = this.pingerFactory.getInstance();
            for (int sequenceId = 1; sequenceId <= pingRequest.getNumberRequests(); ++sequenceId) {
                pinger.ping(pingRequest.getInetAddress(), pingRequest.getTimeout(), pingRequest.getRetries(), pingRequest.getPackageSize(), sequenceId, (PingResponseCallback)callback);
                Thread.sleep(pingRequest.getDelay());
            }
            while (!callback.isDone()) {
                Thread.sleep(250L);
            }
            callback.notifyUI();
            return null;
        });
    }

    public static interface Callback {
        public void onUpdate(PingResult var1);
    }
}

