/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal.operations;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Objects;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.topology.api.AbstractOperation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.netutils.internal.PingWindow;
import org.opennms.features.topology.netutils.internal.service.PingService;
import org.opennms.netmgt.icmp.PingerFactory;

public class PingOperation
extends AbstractOperation {
    private PingerFactory pingerFactory;

    public PingOperation(PingerFactory pingerFactory) {
        this.pingerFactory = Objects.requireNonNull(pingerFactory);
    }

    public void execute(List<VertexRef> targets, OperationContext operationContext) {
        VertexRef target = targets.get(0);
        Vertex vertex = PingOperation.getVertexItem((OperationContext)operationContext, (VertexRef)target);
        new PingWindow(vertex, new PingService(this.pingerFactory)).open();
    }

    public boolean enabled(List<VertexRef> targets, OperationContext operationContext) {
        String ipAddress;
        if (targets.size() == 1 && !Strings.isNullOrEmpty((String)(ipAddress = PingOperation.getVertexItem((OperationContext)operationContext, (VertexRef)targets.get(0)).getIpAddress()))) {
            try {
                InetAddressUtils.getInetAddress((String)ipAddress);
                return true;
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        }
        return false;
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        return targets != null && targets.size() > 0;
    }

    public String getId() {
        return "ping";
    }
}

