/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal.service;

import java.util.Objects;
import java.util.stream.LongStream;
import org.opennms.features.topology.netutils.internal.service.PingResult;

public class PingResultSummary {
    private PingResult result;

    PingResultSummary(PingResult result) {
        this.result = Objects.requireNonNull(result);
    }

    public int getPacketsTransmitted() {
        return this.result.getSequences().size();
    }

    public double getPacketLoss() {
        return 1.0 - (double)this.getPacketsReceived() / (double)this.getPacketsTransmitted();
    }

    public int getPacketsReceived() {
        return (int)this.result.getSequences().stream().filter(eachSequence -> eachSequence.isSuccess()).count();
    }

    public long getMin() {
        return this.getDiffTimeNanos().min().orElse(0L);
    }

    public double getAvg() {
        return this.getDiffTimeNanos().average().orElse(0.0);
    }

    public long getMax() {
        return this.getDiffTimeNanos().max().orElse(0L);
    }

    public double getStdDev() {
        return this.getAvg() - (double)this.getMin();
    }

    private LongStream getDiffTimeNanos() {
        return this.result.getSequences().stream().filter(eachSequence -> eachSequence.isSuccess()).mapToLong(eachSequence -> eachSequence.getResponse().getReceivedTimeNanos() - eachSequence.getResponse().getSentTimeNanos());
    }
}

