/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.link;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.features.topology.link.Layout;
import org.opennms.features.topology.link.TopologyProvider;

public class TopologyLinkBuilder {
    public static final String PARAMETER_LAYOUT = "layout";
    public static final String PARAMETER_FOCUS_VERTICES = "focus-vertices";
    public static final String PARAMETER_SEMANTIC_ZOOM_LEVEL = "szl";
    public static final String PARAMETER_GRAPH_PROVIDER = "provider";
    public static final String PARAMETER_LAYER_NAMESPACE = "layer-namespace";
    private static final String TOPOLOGY_URL = "/opennms/topology";
    private Layout layout;
    private List<String> vertexIds = new ArrayList<String>();
    private int szl = 1;
    private TopologyProvider provider = TopologyProvider.ENLINKD;
    private String layer;

    public TopologyLinkBuilder layout(String layoutString) {
        return this.layout(Layout.createFromLabel(layoutString));
    }

    public TopologyLinkBuilder layout(Layout layout) {
        if (layout != null) {
            this.layout = layout;
        }
        return this;
    }

    public TopologyLinkBuilder focus(String ... vertexId) {
        if (vertexId != null) {
            return this.focus(Arrays.asList(vertexId));
        }
        return this;
    }

    public TopologyLinkBuilder focus(List<String> vertexIds) {
        if (vertexIds != null) {
            vertexIds.stream().filter(id -> id != null).map(id -> id.trim()).filter(id -> !id.trim().isEmpty()).collect(Collectors.toList());
            this.vertexIds = Collections.unmodifiableList(vertexIds);
        }
        return this;
    }

    public TopologyLinkBuilder szl(int szl) {
        this.szl = szl >= 0 ? szl : 1;
        return this;
    }

    public TopologyLinkBuilder provider(TopologyProvider provider) {
        if (provider != null && provider.getLabel() != null && !provider.getLabel().isEmpty()) {
            this.provider = provider;
        }
        return this;
    }

    public TopologyLinkBuilder layer(String namespace) {
        if (namespace != null && !namespace.isEmpty()) {
            this.layer = namespace;
        }
        return this;
    }

    public String getLink() {
        ArrayList<String> parameters = new ArrayList<String>();
        try {
            parameters.add(TopologyLinkBuilder.parameter(PARAMETER_GRAPH_PROVIDER, this.provider.getLabel()));
            parameters.add(TopologyLinkBuilder.parameter(PARAMETER_SEMANTIC_ZOOM_LEVEL, Integer.toString(this.szl)));
            if (!this.vertexIds.isEmpty()) {
                parameters.add(TopologyLinkBuilder.parameter(PARAMETER_FOCUS_VERTICES, this.vertexIds.stream().collect(Collectors.joining(","))));
            }
            if (this.layout != null) {
                parameters.add(TopologyLinkBuilder.parameter(PARAMETER_LAYOUT, this.layout.getLabel()));
            }
            if (this.layer != null) {
                parameters.add(TopologyLinkBuilder.parameter(PARAMETER_LAYER_NAMESPACE, this.layer));
            }
            if (!parameters.isEmpty()) {
                return "/opennms/topology?" + parameters.stream().collect(Collectors.joining("&"));
            }
            return TOPOLOGY_URL;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String parameter(String parameterName, String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(parameterName, StandardCharsets.UTF_8.name()) + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8.name());
    }
}

