/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.link;

import java.util.Objects;

public enum Layout {
    CIRCLE("Circle Layout"),
    D3("D3 Layout"),
    FR("FR Layout"),
    HIERARCHY("Hierarchy Layout"),
    ISOM("ISOM Layout"),
    KK("KK Layout"),
    REAL("Real Ultimate Layout"),
    SPRING("Spring Layout"),
    MANUAL("Manual Layout");

    private final String label;

    private Layout(String label) {
        this.label = Objects.requireNonNull(label);
    }

    public String getLabel() {
        return this.label;
    }

    public static Layout createFromLabel(String label) {
        for (Layout eachLayout : Layout.values()) {
            if (!eachLayout.getLabel().equals(label)) continue;
            return eachLayout;
        }
        return null;
    }
}

