/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.support.FocusStrategyImplementation;
import org.opennms.features.topology.api.support.hops.DefaultVertexHopCriteria;
import org.opennms.features.topology.api.support.hops.VertexHopCriteria;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.VertexRef;

public enum FocusStrategy {
    EMPTY((graph, arguments) -> Lists.newArrayList()),
    ALL((graph, arguments) -> graph.getVertices(new Criteria[0]).stream().map(DefaultVertexHopCriteria::new).collect(Collectors.toList())),
    FIRST((topologyProvider, arguments) -> {
        List collected = topologyProvider.getVertices(new Criteria[0]).stream().map(DefaultVertexHopCriteria::new).collect(Collectors.toList());
        if (!collected.isEmpty()) {
            return collected.subList(0, 1);
        }
        return Lists.newArrayList();
    }),
    SPECIFIC((graph, arguments) -> {
        Objects.requireNonNull(arguments);
        List collected = Arrays.stream(arguments).map(eachArgument -> new DefaultVertexRef(graph.getNamespace(), (String)eachArgument)).map(eachVertexRef -> graph.getVertex((VertexRef)eachVertexRef, new Criteria[0])).filter(Objects::nonNull).map(DefaultVertexHopCriteria::new).collect(Collectors.toList());
        return collected;
    });

    private final FocusStrategyImplementation implementation;

    private FocusStrategy(FocusStrategyImplementation implementation) {
        this.implementation = implementation;
    }

    public List<VertexHopCriteria> getFocusCriteria(BackendGraph graph, String ... arguments) {
        return this.implementation.determine(graph, arguments);
    }

    public static FocusStrategy getStrategy(String input, FocusStrategy defaultValue) {
        for (FocusStrategy eachStrategy : FocusStrategy.values()) {
            if (!eachStrategy.name().equalsIgnoreCase(input)) continue;
            return eachStrategy;
        }
        return defaultValue;
    }
}

