/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo.simple;

import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.simple.SimpleConnector;
import org.opennms.features.topology.api.topo.simple.SimpleGraph;

public class SimpleGraphBuilder {
    private final BackendGraph m_simpleGraph;
    private AbstractVertex m_currentVertex;
    private AbstractEdge m_currentEdge;

    public SimpleGraphBuilder(String namespace) {
        this.m_simpleGraph = new SimpleGraph(namespace);
    }

    public SimpleGraphBuilder vertex(String id) {
        this.m_currentVertex = new AbstractVertex(this.ns(), id);
        this.m_simpleGraph.addVertices(this.m_currentVertex);
        return this;
    }

    public SimpleGraphBuilder vLabel(String label) {
        this.m_currentVertex.setLabel(label);
        return this;
    }

    public SimpleGraphBuilder vTooltip(String tooltipText) {
        this.m_currentVertex.setTooltipText(tooltipText);
        return this;
    }

    public SimpleGraphBuilder vIconKey(String iconKey) {
        this.m_currentVertex.setIconKey(iconKey);
        return this;
    }

    public SimpleGraphBuilder vStyleName(String styleName) {
        this.m_currentVertex.setStyleName(styleName);
        return this;
    }

    public SimpleGraphBuilder vX(int x) {
        this.m_currentVertex.setX(x);
        return this;
    }

    public SimpleGraphBuilder vY(int y) {
        this.m_currentVertex.setY(y);
        return this;
    }

    public SimpleGraphBuilder edge(String id, String srcId, String tgtId) {
        VertexRef tgtVertex;
        VertexRef srcVertex = this.m_simpleGraph.getVertex(this.ns(), srcId);
        if (srcVertex == null) {
            srcVertex = new DefaultVertexRef(this.ns(), srcId);
        }
        if ((tgtVertex = this.m_simpleGraph.getVertex(this.ns(), tgtId)) == null) {
            tgtVertex = new DefaultVertexRef(this.ns(), tgtId);
        }
        SimpleConnector source = new SimpleConnector(this.ns(), srcId + "-" + id + "-connector", srcVertex);
        SimpleConnector target = new SimpleConnector(this.ns(), tgtId + "-" + id + "-connector", tgtVertex);
        this.m_currentEdge = new AbstractEdge(this.ns(), id, source, target);
        source.setEdge(this.m_currentEdge);
        target.setEdge(this.m_currentEdge);
        this.m_simpleGraph.addEdges(this.m_currentEdge);
        return this;
    }

    public SimpleGraphBuilder eLabel(String label) {
        this.m_currentEdge.setLabel(label);
        return this;
    }

    public SimpleGraphBuilder eTooltip(String tooltipText) {
        this.m_currentEdge.setTooltipText(tooltipText);
        return this;
    }

    public SimpleGraphBuilder eStyleName(String styleName) {
        this.m_currentEdge.setStyleName(styleName);
        return this;
    }

    public BackendGraph get() {
        return this.m_simpleGraph;
    }

    private String ns() {
        return this.m_simpleGraph.getNamespace();
    }
}

