/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo.simple;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.support.hops.DefaultVertexHopCriteria;
import org.opennms.features.topology.api.topo.AbstractSearchProvider;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.SearchResult;
import org.opennms.features.topology.api.topo.VertexRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleSearchProvider
extends AbstractSearchProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleSearchProvider.class);

    @Override
    public boolean contributesTo(String namespace) {
        String graphNamespace = this.getSearchProviderNamespace();
        return graphNamespace != null ? graphNamespace.equalsIgnoreCase(namespace) : false;
    }

    @Override
    public boolean supportsPrefix(String searchPrefix) {
        String graphNamespace = this.getSearchProviderNamespace();
        String graphPrefix = graphNamespace != null ? graphNamespace : "";
        return SimpleSearchProvider.supportsPrefix(graphPrefix + "=", searchPrefix);
    }

    public abstract List<? extends VertexRef> queryVertices(SearchQuery var1, GraphContainer var2);

    @Override
    public List<SearchResult> query(SearchQuery searchQuery, GraphContainer container) {
        LOG.info("SimpleSearchProvider->query: called with search query: '{}'", (Object)searchQuery);
        List<SearchResult> results = this.queryVertices(searchQuery, container).stream().map(v -> {
            SearchResult searchResult = new SearchResult((VertexRef)v, true, false);
            return searchResult;
        }).collect(Collectors.toList());
        LOG.info("SimpleSearchProvider->query: found {} results: {}", (Object)results.size(), results);
        return results;
    }

    @Override
    public Set<VertexRef> getVertexRefsBy(SearchResult searchResult, GraphContainer container) {
        DefaultVertexRef vertexToFocus = new DefaultVertexRef(searchResult.getNamespace(), searchResult.getId(), searchResult.getLabel());
        return Sets.newHashSet((Object[])new VertexRef[]{vertexToFocus});
    }

    @Override
    public void addVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SimpleSearchProvider->addVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        DefaultVertexHopCriteria criterion = new DefaultVertexHopCriteria(new DefaultVertexRef(searchResult.getNamespace(), searchResult.getId(), searchResult.getLabel()));
        container.addCriteria(criterion);
        LOG.debug("SimpleSearchProvider->addVertexHop: adding hop criteria {}.", (Object)criterion);
        LOG.debug("SimpleSearchProvider->addVertexHop: current criteria {}.", (Object)Arrays.toString(container.getCriteria()));
    }

    @Override
    public void removeVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SimpleSearchProvider->removeVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        DefaultVertexHopCriteria criterion = new DefaultVertexHopCriteria(new DefaultVertexRef(searchResult.getNamespace(), searchResult.getId(), searchResult.getLabel()));
        container.removeCriteria(criterion);
        LOG.debug("SimpleSearchProvider->removeVertexHopCriteria: current criteria {}.", (Object)Arrays.toString(container.getCriteria()));
    }
}

