/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.browsers;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;

public interface SelectionChangedListener {
    public void selectionChanged(Selection var1);

    public static class AlarmNodeIdSelection
    implements Selection {
        private final Set<Integer> selectedNodeIds;

        public AlarmNodeIdSelection(Collection<Integer> selectedNodeIds) {
            this.selectedNodeIds = Sets.newHashSet(selectedNodeIds);
        }

        @Override
        public List<Restriction> toRestrictions() {
            if (this.selectedNodeIds != null && !this.selectedNodeIds.isEmpty()) {
                return Lists.newArrayList((Object[])new Restriction[]{Restrictions.in((String)"node.id", this.selectedNodeIds)});
            }
            return Lists.newArrayList((Object[])new Restriction[]{Restrictions.isNull((String)"node.id")});
        }
    }

    public static class IdSelection<T extends Serializable>
    implements Selection {
        private final Set<T> selectedIds;

        public IdSelection(Collection<T> selectedIds) {
            this.selectedIds = Sets.newHashSet(selectedIds);
        }

        @Override
        public List<Restriction> toRestrictions() {
            if (this.selectedIds != null && !this.selectedIds.isEmpty()) {
                return Lists.newArrayList((Object[])new Restriction[]{Restrictions.in((String)"id", this.selectedIds)});
            }
            return Lists.newArrayList((Object[])new Restriction[]{Restrictions.isNull((String)"id")});
        }
    }

    public static interface Selection {
        public static final Selection NONE = new Selection(){

            @Override
            public List<Restriction> toRestrictions() {
                return Lists.newArrayList();
            }
        };

        public List<Restriction> toRestrictions();
    }
}

