/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.opennms.features.topology.api.topo.Criteria;

public class Defaults {
    public static final int DEFAULT_SEMANTIC_ZOOM_LEVEL = 1;
    public static final String DEFAULT_PREFERRED_LAYOUT = "D3 Layout";
    private Supplier<Integer> szlSupplier = () -> 1;
    private Supplier<String> layoutSupplier = () -> "D3 Layout";
    private Supplier<List<Criteria>> criteriaSupplier = Collections::emptyList;

    public Defaults withSemanticZoomLevel(Supplier<Integer> szlSupplier) {
        this.szlSupplier = Objects.requireNonNull(szlSupplier);
        return this;
    }

    public Defaults withPreferredLayout(Supplier<String> layoutSupplier) {
        this.layoutSupplier = Objects.requireNonNull(layoutSupplier);
        return this;
    }

    public Defaults withCriteria(Supplier<List<Criteria>> criteriaSupplier) {
        this.criteriaSupplier = Objects.requireNonNull(criteriaSupplier);
        return this;
    }

    public Defaults withSemanticZoomLevel(int szl) {
        Preconditions.checkArgument((szl >= 0 ? 1 : 0) != 0, (Object)"The semantic zoom level must be greater or equal than 0");
        this.szlSupplier = () -> szl;
        return this;
    }

    public Defaults withPreferredLayout(String layout) {
        this.layoutSupplier = () -> layout;
        return this;
    }

    public int getSemanticZoomLevel() {
        return this.szlSupplier.get();
    }

    public String getPreferredLayout() {
        return this.layoutSupplier.get();
    }

    public List<Criteria> getCriteria() {
        List<Criteria> criterias = this.criteriaSupplier.get();
        if (criterias != null) {
            return Collections.unmodifiableList(criterias);
        }
        return null;
    }
}

