/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexListener;
import org.opennms.features.topology.api.topo.VertexProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.slf4j.LoggerFactory;

public class SimpleVertexProvider
implements VertexProvider {
    private final String m_namespace;
    private final Map<String, Vertex> m_vertexMap = new LinkedHashMap<String, Vertex>();
    private final Set<VertexListener> m_listeners = new CopyOnWriteArraySet<VertexListener>();
    private final Map<VertexRef, VertexRef> m_parents = new HashMap<VertexRef, VertexRef>();
    private final Map<VertexRef, Set<VertexRef>> m_children = new HashMap<VertexRef, Set<VertexRef>>();

    public SimpleVertexProvider(String namespace) {
        this.m_namespace = namespace;
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    @Override
    public boolean contributesTo(String namespace) {
        return false;
    }

    @Override
    public Vertex getVertex(String namespace, String id) {
        return this.getVertex(new DefaultVertexRef(namespace, id), new Criteria[0]);
    }

    @Override
    public Vertex getVertex(VertexRef reference, Criteria ... criteria) {
        return this.getSimpleVertex(reference);
    }

    private Vertex getSimpleVertex(VertexRef reference) {
        if (reference != null && this.getNamespace().equals(reference.getNamespace())) {
            return this.m_vertexMap.get(reference.getId());
        }
        return null;
    }

    @Override
    public List<Vertex> getVertices(Collection<? extends VertexRef> references, Criteria ... criteria) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (VertexRef vertexRef : references) {
            Vertex vertex = this.getSimpleVertex(vertexRef);
            if (vertex == null) continue;
            vertices.add(vertex);
        }
        return vertices;
    }

    @Override
    public List<Vertex> getRootGroup() {
        ArrayList<Vertex> rootGroup = new ArrayList<Vertex>();
        for (Vertex vertex : this.m_vertexMap.values()) {
            if (this.getParent(vertex) != null) continue;
            rootGroup.add(vertex);
        }
        return rootGroup;
    }

    @Override
    public boolean hasChildren(VertexRef group) {
        return this.m_children.containsKey(group);
    }

    @Override
    public Vertex getParent(VertexRef vertex) {
        VertexRef parentRef = this.m_parents.get(vertex);
        return parentRef == null ? null : this.getSimpleVertex(parentRef);
    }

    @Override
    public boolean setParent(VertexRef child, VertexRef parent) {
        if (child.equals(parent)) {
            return false;
        }
        this.getVertex(child, new Criteria[0]).setParent(parent);
        if (parent == null) {
            this.m_parents.remove(child);
        } else {
            this.m_parents.put(child, parent);
        }
        for (Set<VertexRef> vertex : this.m_children.values()) {
            vertex.remove(child);
        }
        boolean retval = false;
        if (parent == null) {
            retval = true;
        } else {
            Set<VertexRef> children = this.m_children.get(parent);
            if (children == null) {
                children = new TreeSet<VertexRef>();
                this.m_children.put(parent, children);
            }
            retval = children.add(child);
        }
        this.fireVertexSetChanged();
        return retval;
    }

    @Override
    public List<Vertex> getChildren(VertexRef group, Criteria ... criteria) {
        Set<VertexRef> children = this.m_children.get(group);
        return children == null ? Collections.emptyList() : this.getVertices(children, new Criteria[0]);
    }

    private void fireVertexSetChanged() {
        for (VertexListener listener : this.m_listeners) {
            listener.vertexSetChanged(this);
        }
    }

    private void fireVerticesAdded(Collection<Vertex> vertices) {
        for (VertexListener listener : this.m_listeners) {
            listener.vertexSetChanged(this, vertices, null, null);
        }
    }

    private void fireVerticesRemoved(List<? extends VertexRef> all) {
        ArrayList<String> ids = new ArrayList<String>(all.size());
        for (VertexRef vertexRef : all) {
            ids.add(vertexRef.getId());
        }
        for (VertexListener vertexListener : this.m_listeners) {
            vertexListener.vertexSetChanged(this, null, null, ids);
        }
    }

    @Override
    public void addVertexListener(VertexListener vertexListener) {
        this.m_listeners.add(vertexListener);
    }

    @Override
    public void removeVertexListener(VertexListener vertexListener) {
        this.m_listeners.remove(vertexListener);
    }

    private void removeVertices(List<? extends VertexRef> vertices) {
        for (VertexRef vertexRef : vertices) {
            LoggerFactory.getLogger(this.getClass()).trace("Removing vertex: {}", (Object)vertexRef);
            this.m_vertexMap.remove(vertexRef.getId());
            this.m_children.remove(vertexRef);
            this.m_parents.remove(vertexRef);
        }
    }

    private void addVertices(Collection<Vertex> vertices) {
        for (Vertex vertex : vertices) {
            if (vertex.getNamespace() == null || vertex.getId() == null) {
                LoggerFactory.getLogger(this.getClass()).warn("Discarding invalid vertex: {}", (Object)vertex);
                continue;
            }
            LoggerFactory.getLogger(this.getClass()).trace("Adding vertex: {}", (Object)vertex);
            this.m_vertexMap.put(vertex.getId(), vertex);
        }
    }

    public void setVertices(List<Vertex> vertices) {
        this.clearVertices();
        this.addVertices(vertices);
        this.fireVertexSetChanged();
    }

    public void add(Vertex ... vertices) {
        this.add(Arrays.asList(vertices));
    }

    public void add(Collection<Vertex> vertices) {
        this.addVertices(vertices);
        this.fireVerticesAdded(vertices);
    }

    public void remove(List<VertexRef> vertices) {
        this.removeVertices(vertices);
        this.fireVerticesRemoved(vertices);
    }

    public void remove(VertexRef ... vertices) {
        this.remove(Arrays.asList(vertices));
    }

    @Override
    public List<Vertex> getVertices(Criteria ... criteria) {
        return Collections.unmodifiableList(new ArrayList<Vertex>(this.m_vertexMap.values()));
    }

    @Override
    public int getSemanticZoomLevel(VertexRef vertex) {
        Vertex parent = this.getParent(vertex);
        return parent == null ? 0 : 1 + this.getSemanticZoomLevel(parent);
    }

    @Override
    public void clearVertices() {
        List<Vertex> all = this.getVertices(new Criteria[0]);
        this.removeVertices(all);
        this.fireVerticesRemoved(all);
    }

    @Override
    public int getVertexTotalCount() {
        return this.m_vertexMap.size();
    }

    @Override
    public boolean containsVertexId(String id) {
        return this.containsVertexId(new DefaultVertexRef(this.getNamespace(), id), new Criteria[0]);
    }

    @Override
    public boolean containsVertexId(VertexRef id, Criteria ... criteria) {
        return this.getVertex(id, criteria) != null;
    }
}

