/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultTopologyProviderInfo;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.DelegatingVertexEdgeProvider;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.Ref;
import org.opennms.features.topology.api.topo.RefComparator;
import org.opennms.features.topology.api.topo.SimpleConnector;
import org.opennms.features.topology.api.topo.SimpleEdgeProvider;
import org.opennms.features.topology.api.topo.SimpleGroup;
import org.opennms.features.topology.api.topo.SimpleLeafVertex;
import org.opennms.features.topology.api.topo.SimpleVertexProvider;
import org.opennms.features.topology.api.topo.TopologyProviderInfo;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTopologyProvider
extends DelegatingVertexEdgeProvider
implements GraphProvider {
    protected static final String SIMPLE_VERTEX_ID_PREFIX = "v";
    protected static final String SIMPLE_GROUP_ID_PREFIX = "g";
    protected static final String SIMPLE_EDGE_ID_PREFIX = "e";
    protected TopologyProviderInfo topologyProviderInfo = new DefaultTopologyProviderInfo();
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTopologyProvider.class);
    private IdGenerator groupIdGenerator = new IdGenerator("g", this){

        @Override
        public List<Ref> getContent() {
            return new ArrayList<Ref>(AbstractTopologyProvider.this.getGroups());
        }
    };
    private IdGenerator edgeIdGenerator = new IdGenerator("e", this){

        @Override
        public List<Ref> getContent() {
            return new ArrayList<Ref>(AbstractTopologyProvider.this.getEdges(new Criteria[0]));
        }
    };
    private IdGenerator vertexIdGenerator = new IdGenerator("v", this){

        @Override
        public List<Ref> getContent() {
            return new ArrayList<Ref>(AbstractTopologyProvider.this.getVerticesWithoutGroups());
        }
    };

    protected String getNextVertexId() {
        return this.vertexIdGenerator.getNextId();
    }

    protected String getNextGroupId() {
        return this.groupIdGenerator.getNextId();
    }

    protected String getNextEdgeId() {
        return this.edgeIdGenerator.getNextId();
    }

    protected AbstractTopologyProvider(String namespace) {
        super(namespace);
    }

    protected AbstractTopologyProvider(SimpleVertexProvider vertexProvider, SimpleEdgeProvider edgeProvider) {
        super(vertexProvider, edgeProvider);
    }

    public List<Vertex> getVerticesWithoutGroups() {
        return new ArrayList<Vertex>(Collections2.filter(this.getVertices(new Criteria[0]), (Predicate)new Predicate<Vertex>(){

            public boolean apply(Vertex input) {
                return input != null && !input.isGroup();
            }
        }));
    }

    public List<Vertex> getGroups() {
        return new ArrayList<Vertex>(Collections2.filter(this.getVertices(new Criteria[0]), (Predicate)new Predicate<Vertex>(){

            public boolean apply(Vertex input) {
                return input != null && input.isGroup();
            }
        }));
    }

    @Override
    public final void removeVertex(VertexRef ... vertexId) {
        for (VertexRef vertex : vertexId) {
            if (vertex == null) continue;
            this.getSimpleVertexProvider().remove(vertexId);
            this.removeEdges(this.getEdgeIdsForVertex(vertex));
        }
    }

    @Override
    public final void addVertices(Vertex ... vertices) {
        this.getSimpleVertexProvider().add(vertices);
    }

    @Override
    public final AbstractVertex addVertex(int x, int y) {
        String id = this.getNextVertexId();
        return this.addVertex(id, x, y);
    }

    protected final AbstractVertex addVertex(String id, int x, int y) {
        LoggerFactory.getLogger(this.getClass()).debug("Adding vertex in {} with ID: {}", (Object)this.getClass().getSimpleName(), (Object)id);
        SimpleLeafVertex vertex = new SimpleLeafVertex(this.getNamespace(), id, x, y);
        this.getSimpleVertexProvider().add(vertex);
        return vertex;
    }

    @Override
    public final AbstractVertex addGroup(String groupName, String groupIconKey) {
        String nextGroupId = this.getNextGroupId();
        return this.addGroup(nextGroupId, groupIconKey, groupName);
    }

    protected final AbstractVertex addGroup(String groupId, String iconKey, String label) {
        SimpleGroup vertex = new SimpleGroup(this.getNamespace(), groupId);
        if (this.containsVertexId(vertex, new Criteria[0])) {
            throw new IllegalArgumentException("A vertex or group with id " + groupId + " already exists!");
        }
        LoggerFactory.getLogger(this.getClass()).debug("Adding a group: {}", (Object)groupId);
        vertex.setLabel(label);
        vertex.setIconKey(iconKey);
        this.addVertices(vertex);
        return vertex;
    }

    @Override
    public final void addEdges(Edge ... edges) {
        this.getSimpleEdgeProvider().add(edges);
    }

    @Override
    public final void removeEdges(EdgeRef ... edge) {
        this.getSimpleEdgeProvider().remove(edge);
    }

    @Override
    public final EdgeRef[] getEdgeIdsForVertex(VertexRef vertex) {
        if (vertex == null) {
            return new EdgeRef[0];
        }
        ArrayList<Edge> retval = new ArrayList<Edge>();
        for (Edge edge : this.getEdges(new Criteria[0])) {
            if (new RefComparator().compare(edge.getSource().getVertex(), vertex) != 0 && new RefComparator().compare(edge.getTarget().getVertex(), vertex) != 0) continue;
            retval.add(edge);
        }
        return retval.toArray(new EdgeRef[0]);
    }

    @Override
    public final Map<VertexRef, Set<EdgeRef>> getEdgeIdsForVertices(VertexRef ... vertices) {
        List<Edge> edges = this.getEdges(new Criteria[0]);
        HashMap<VertexRef, Set<EdgeRef>> retval = new HashMap<VertexRef, Set<EdgeRef>>();
        for (VertexRef vertex : vertices) {
            if (vertex == null) continue;
            HashSet<Edge> edgeSet = new HashSet<Edge>();
            for (Edge edge : edges) {
                if (new RefComparator().compare(edge.getSource().getVertex(), vertex) != 0 && new RefComparator().compare(edge.getTarget().getVertex(), vertex) != 0) continue;
                edgeSet.add(edge);
            }
            retval.put(vertex, edgeSet);
        }
        return retval;
    }

    @Override
    public Edge connectVertices(VertexRef sourceVertextId, VertexRef targetVertextId) {
        String nextEdgeId = this.getNextEdgeId();
        return this.connectVertices(nextEdgeId, sourceVertextId, targetVertextId, this.getNamespace());
    }

    protected final AbstractEdge connectVertices(String id, VertexRef sourceId, VertexRef targetId, String namespace) {
        if (sourceId == null) {
            if (targetId == null) {
                LOG.warn("Source and target vertices are null");
                return null;
            }
            LOG.warn("Source vertex is null");
            return null;
        }
        if (targetId == null) {
            LOG.warn("Target vertex is null");
            return null;
        }
        SimpleConnector source = new SimpleConnector(sourceId.getNamespace(), sourceId.getId() + "-" + id + "-connector", sourceId);
        SimpleConnector target = new SimpleConnector(targetId.getNamespace(), targetId.getId() + "-" + id + "-connector", targetId);
        AbstractEdge edge = new AbstractEdge(namespace, id, source, target);
        this.addEdges(edge);
        return edge;
    }

    @Override
    public void resetContainer() {
        this.clearVertices();
        this.clearEdges();
        this.clearCounters();
    }

    protected void clearCounters() {
        this.vertexIdGenerator.reset();
        this.groupIdGenerator.reset();
        this.edgeIdGenerator.reset();
    }

    @Override
    public abstract void refresh();

    @Override
    public TopologyProviderInfo getTopologyProviderInfo() {
        return this.topologyProviderInfo;
    }

    public void setTopologyProviderInfo(TopologyProviderInfo topologyProviderInfo) {
        this.topologyProviderInfo = topologyProviderInfo;
    }

    protected static SelectionChangedListener.Selection getSelection(String namespace, List<VertexRef> selectedVertices, ContentType type) {
        Set<Integer> nodeIds = selectedVertices.stream().filter(v -> namespace.equals(v.getNamespace())).filter(v -> v instanceof AbstractVertex).map(v -> (AbstractVertex)v).map(v -> v.getNodeID()).filter(nodeId -> nodeId != null).collect(Collectors.toSet());
        if (type == ContentType.Alarm) {
            return new SelectionChangedListener.AlarmNodeIdSelection(nodeIds);
        }
        if (type == ContentType.Node) {
            return new SelectionChangedListener.IdSelection<Integer>(nodeIds);
        }
        return SelectionChangedListener.Selection.NONE;
    }

    protected static abstract class IdGenerator {
        private final AbstractTopologyProvider provider;
        private final String idPrefix;
        private int counter;
        private boolean initialized;

        protected IdGenerator(String idPrefix, AbstractTopologyProvider provider) {
            this.idPrefix = idPrefix;
            this.provider = provider;
        }

        public String getNextId() {
            try {
                this.initializeIfNeeded();
                while (!this.isValid(this.createId())) {
                    ++this.counter;
                }
                String string = this.createId();
                return string;
            }
            finally {
                ++this.counter;
            }
        }

        private String createId() {
            return this.idPrefix + this.counter;
        }

        private int getInitValue() {
            int max = 0;
            for (Ref ref : this.getContent()) {
                if (!ref.getId().startsWith(this.idPrefix)) continue;
                max = Math.max(max, this.extractIntegerFromId(ref.getId()));
            }
            return max;
        }

        private boolean isValid(String generatedId) {
            return !this.provider.containsVertexId(new DefaultVertexRef(this.provider.getNamespace(), generatedId), new Criteria[0]);
        }

        public void reset() {
            this.counter = 0;
            this.initialized = false;
        }

        private int extractIntegerFromId(String id) {
            try {
                return Integer.parseInt(id.replaceAll(this.idPrefix, "").trim());
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
            catch (IllegalArgumentException ilargex) {
                return 0;
            }
        }

        private void initializeIfNeeded() {
            if (!this.initialized) {
                this.counter = this.getInitValue();
                this.initialized = true;
            }
        }

        public abstract List<Ref> getContent();
    }
}

