/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support.breadcrumbs;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.Callbacks;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.support.breadcrumbs.Breadcrumb;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.VertexRef;

public class BreadcrumbCriteria
extends Criteria {
    private List<Breadcrumb> breadcrumbs = Lists.newArrayList();

    public void setNewRoot(Breadcrumb breadcrumb) {
        if (this.breadcrumbs.contains(breadcrumb)) {
            int index = this.breadcrumbs.indexOf(breadcrumb);
            this.breadcrumbs = this.breadcrumbs.subList(0, index + 1);
        } else {
            this.breadcrumbs.add(breadcrumb);
        }
    }

    public void clear() {
        this.breadcrumbs.clear();
    }

    public List<Breadcrumb> getBreadcrumbs() {
        return Collections.unmodifiableList(this.breadcrumbs);
    }

    public boolean isEmpty() {
        return this.breadcrumbs.isEmpty();
    }

    @Override
    public Criteria.ElementType getType() {
        return Criteria.ElementType.GRAPH;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.breadcrumbs);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof BreadcrumbCriteria) {
            BreadcrumbCriteria other = (BreadcrumbCriteria)obj;
            boolean equals = Objects.equals(this.breadcrumbs, other.breadcrumbs);
            return equals;
        }
        return false;
    }

    public void setBreadcrumbs(List<Breadcrumb> breadcrumbs) {
        this.breadcrumbs = Lists.newArrayList((Iterable)Objects.requireNonNull(breadcrumbs));
    }

    private Breadcrumb getNext(Breadcrumb breadcrumb) {
        int index = this.breadcrumbs.indexOf(breadcrumb);
        if (index == this.breadcrumbs.size() - 1) {
            return null;
        }
        return this.breadcrumbs.get(index + 1);
    }

    private Breadcrumb getPrevious(Breadcrumb breadcrumb) {
        int index = this.breadcrumbs.indexOf(breadcrumb);
        if (index == 0) {
            return null;
        }
        return this.breadcrumbs.get(index - 1);
    }

    private boolean isLeaf(Breadcrumb breadcrumb) {
        return this.breadcrumbs.indexOf(breadcrumb) == this.breadcrumbs.size() - 1;
    }

    public void handleClick(Breadcrumb breadcrumb, GraphContainer graphContainer) {
        GraphProvider targetGraphProvider = graphContainer.getTopologyServiceClient().getGraphProviderBy(breadcrumb.getTargetNamespace());
        if (this.isLeaf(breadcrumb)) {
            if (breadcrumb.getSourceVertices().isEmpty()) {
                List<VertexRef> defaultFocus = targetGraphProvider.getDefaults().getCriteria().stream().filter(c -> c instanceof VertexHopGraphProvider.VertexHopCriteria).map(c -> ((VertexHopGraphProvider.VertexHopCriteria)c).getVertices()).flatMap(v -> v.stream()).collect(Collectors.toList());
                BreadcrumbCriteria.handleClick(graphContainer, targetGraphProvider, defaultFocus, breadcrumb);
            } else {
                List<VertexRef> oppositeVertices = breadcrumb.getSourceVertices().stream().flatMap(sourceVertex -> BreadcrumbCriteria.getOppositeVertices(graphContainer, breadcrumb.getTargetNamespace(), sourceVertex).stream()).collect(Collectors.toList());
                BreadcrumbCriteria.handleClick(graphContainer, targetGraphProvider, oppositeVertices, breadcrumb);
            }
        } else {
            Breadcrumb next = this.getNext(breadcrumb);
            BreadcrumbCriteria.handleClick(graphContainer, targetGraphProvider, next.getSourceVertices(), breadcrumb);
        }
    }

    private static List<VertexRef> getOppositeVertices(GraphContainer graphContainer, String targetNamespace, VertexRef sourceVertex) {
        Collection<VertexRef> oppositeVertices = graphContainer.getTopologyServiceClient().getOppositeVertices(sourceVertex);
        List<VertexRef> targetVertices = oppositeVertices.stream().filter(v -> v.getNamespace().matches(targetNamespace)).collect(Collectors.toList());
        return targetVertices;
    }

    private static void handleClick(GraphContainer graphContainer, GraphProvider targetGraphProvider, List<VertexRef> verticesToFocus, Breadcrumb breadcrumb) {
        String targetNamespace = targetGraphProvider.getNamespace();
        String currentNamespace = graphContainer.getTopologyServiceClient().getNamespace();
        if (!currentNamespace.equals(targetNamespace)) {
            BreadcrumbCriteria breadcrumbCriteria = BreadcrumbCriteria.getBreadcrumbCriteria(graphContainer);
            graphContainer.selectTopologyProvider(targetGraphProvider, Callbacks.applyDefaults(), (graphContainer1, graphProvider) -> graphContainer1.addCriteria(breadcrumbCriteria));
            breadcrumbCriteria.setNewRoot(breadcrumb);
        }
        BreadcrumbCriteria.getCriteriaForGraphContainer(graphContainer, VertexHopGraphProvider.VertexHopCriteria.class).forEach(c -> graphContainer.removeCriteria((Criteria)c));
        verticesToFocus.forEach(v -> graphContainer.addCriteria(new VertexHopGraphProvider.DefaultVertexHopCriteria((VertexRef)v)));
        graphContainer.setDirty(true);
        graphContainer.redoLayout();
    }

    private static BreadcrumbCriteria getBreadcrumbCriteria(GraphContainer graphContainer) {
        return Criteria.getSingleCriteriaForGraphContainer(graphContainer, BreadcrumbCriteria.class, true);
    }
}

