/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opennms.features.topology.api.GraphContainer;

public abstract class Criteria {
    private volatile AtomicBoolean m_criteriaDirty = new AtomicBoolean(Boolean.TRUE);

    public static <T extends Criteria> T getSingleCriteriaForGraphContainer(GraphContainer graphContainer, Class<T> criteriaClass, boolean createIfAbsent) {
        Criteria[] criteria = graphContainer.getCriteria();
        if (criteria != null) {
            for (Criteria criterium : criteria) {
                try {
                    Criteria hopCriteria = (Criteria)criteriaClass.cast(criterium);
                    return (T)hopCriteria;
                }
                catch (ClassCastException classCastException) {
                }
            }
        }
        if (createIfAbsent) {
            Criteria hopCriteria;
            try {
                hopCriteria = (Criteria)criteriaClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Cannot create instance of " + criteriaClass.getName() + " with empty constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot create instance of " + criteriaClass.getName() + " with empty constructor", e);
            }
            graphContainer.addCriteria(hopCriteria);
            return (T)hopCriteria;
        }
        return null;
    }

    public static <T extends Criteria> Set<T> getCriteriaForGraphContainer(GraphContainer graphContainer, Class<T> criteriaClass) {
        HashSet<Criteria> retval = new HashSet<Criteria>();
        Criteria[] criteria = graphContainer.getCriteria();
        if (criteria != null) {
            for (Criteria criterium : criteria) {
                try {
                    Criteria hopCriteria = (Criteria)criteriaClass.cast(criterium);
                    retval.add(hopCriteria);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return retval;
    }

    public abstract ElementType getType();

    public abstract String getNamespace();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public void resetDirty() {
        this.setDirty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        AtomicBoolean atomicBoolean = this.m_criteriaDirty;
        synchronized (atomicBoolean) {
            return this.m_criteriaDirty.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDirty(boolean isDirty) {
        AtomicBoolean atomicBoolean = this.m_criteriaDirty;
        synchronized (atomicBoolean) {
            this.m_criteriaDirty.set(isDirty);
        }
    }

    public static enum ElementType {
        GRAPH,
        VERTEX,
        EDGE;

    }
}

