/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.SelectionContext;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.VertexRef;

public class DefaultSelectionContext
implements SelectionContext {
    private final Set<VertexRef> m_selectedVertices = Collections.synchronizedSet(new HashSet());
    private final Set<EdgeRef> m_selectedEdges = Collections.synchronizedSet(new HashSet());
    private final GraphContainer m_graphContainer;

    public DefaultSelectionContext(GraphContainer graphContainer) {
        this.m_graphContainer = graphContainer;
    }

    @Override
    public boolean isVertexRefSelected(VertexRef vertexRef) {
        return this.m_selectedVertices.contains(vertexRef);
    }

    private void setVertexRefSelected(VertexRef ref, boolean selected) {
        if (selected) {
            this.m_selectedVertices.add(ref);
        } else {
            this.m_selectedVertices.remove(ref);
        }
    }

    @Override
    public boolean isEdgeRefSelected(EdgeRef edgeRef) {
        return this.m_selectedEdges.contains(edgeRef);
    }

    private void setEdgeRefSelected(EdgeRef edgeRef, boolean selected) {
        if (selected) {
            this.m_selectedEdges.add(edgeRef);
        } else {
            this.m_selectedEdges.remove(edgeRef);
        }
    }

    @Override
    public Collection<VertexRef> getSelectedVertexRefs() {
        return Collections.unmodifiableSet(this.m_selectedVertices);
    }

    @Override
    public Collection<EdgeRef> getSelectedEdgeRefs() {
        return Collections.unmodifiableSet(this.m_selectedEdges);
    }

    @Override
    public GraphContainer getGraphContainer() {
        return this.m_graphContainer;
    }

    @Override
    public boolean selectVertexRefs(Collection<? extends VertexRef> vertexRefs) {
        HashSet<VertexRef> oldSet = new HashSet<VertexRef>();
        oldSet.addAll(this.getSelectedVertexRefs());
        for (VertexRef vertexRef : vertexRefs) {
            this.setVertexRefSelected(vertexRef, true);
        }
        return !oldSet.equals(this.getSelectedVertexRefs());
    }

    @Override
    public boolean deselectVertexRefs(Collection<? extends VertexRef> vertexRefs) {
        HashSet<VertexRef> oldSet = new HashSet<VertexRef>();
        oldSet.addAll(this.getSelectedVertexRefs());
        for (VertexRef vertexRef : vertexRefs) {
            this.setVertexRefSelected(vertexRef, false);
        }
        return !oldSet.equals(this.getSelectedVertexRefs());
    }

    @Override
    public boolean deselectAll() {
        return this.setSelectedVertexRefs(Collections.emptySet()) || this.setSelectedEdgeRefs(Collections.emptySet());
    }

    private void doDeselectAll() {
        this.m_selectedEdges.clear();
        this.m_selectedVertices.clear();
    }

    @Override
    public boolean setSelectedVertexRefs(Collection<? extends VertexRef> vertexRefs) {
        HashSet<VertexRef> oldSet = new HashSet<VertexRef>();
        oldSet.addAll(this.getSelectedVertexRefs());
        this.doDeselectAll();
        this.selectVertexRefs(vertexRefs);
        return !oldSet.equals(this.getSelectedVertexRefs());
    }

    @Override
    public boolean setSelectedEdgeRefs(Collection<? extends EdgeRef> edgeRefs) {
        HashSet<EdgeRef> oldSet = new HashSet<EdgeRef>();
        oldSet.addAll(this.getSelectedEdgeRefs());
        this.doDeselectAll();
        for (EdgeRef edgeRef : edgeRefs) {
            this.setEdgeRefSelected(edgeRef, true);
        }
        return !oldSet.equals(this.getSelectedEdgeRefs());
    }
}

