/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api;

import org.opennms.features.topology.api.Point;

public class BoundingBox {
    private int m_left = Integer.MAX_VALUE;
    private int m_top = Integer.MAX_VALUE;
    private int m_right = Integer.MIN_VALUE;
    private int m_bottom = Integer.MIN_VALUE;

    public BoundingBox() {
    }

    public BoundingBox(BoundingBox box) {
        this.m_left = box.m_left;
        this.m_right = box.m_right;
        this.m_top = box.m_top;
        this.m_bottom = box.m_bottom;
    }

    public BoundingBox(int x, int y, int width, int height) {
        this.m_left = x;
        this.m_top = y;
        this.m_right = x + width;
        this.m_bottom = y + height;
    }

    public BoundingBox(Point center, int width, int height) {
        this.m_left = (int)center.getX() - width / 2;
        this.m_top = (int)center.getY() - height / 2;
        this.m_right = this.m_left + width;
        this.m_bottom = this.m_top + height;
    }

    public int getX() {
        return this.m_left;
    }

    public int getY() {
        return this.m_top;
    }

    public int getWidth() {
        return this.m_right - this.m_left;
    }

    public int getHeight() {
        return this.m_bottom - this.m_top;
    }

    public void addPoint(Point location) {
        this.m_left = Math.min(this.m_left, (int)location.getX());
        this.m_right = Math.max(this.m_right, (int)location.getX());
        this.m_top = Math.min(this.m_top, (int)location.getY());
        this.m_bottom = Math.max(this.m_bottom, (int)location.getY());
    }

    public Point getCenter() {
        return new Point(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2);
    }

    public void setCenter(Point center) {
        this.m_left = (int)center.getX() - this.getWidth() / 2;
        this.m_top = (int)center.getY() - this.getHeight() / 2;
    }

    public BoundingBox computeWithAspectRatio(double R) {
        double r = this.getAspectRatio();
        int width = (int)(r < R ? Math.round((double)this.getHeight() * R) : (long)this.getWidth());
        int height = (int)(r < R ? (long)this.getHeight() : Math.round((double)this.getWidth() / R));
        Point center = this.getCenter();
        int x = (int)center.getX() - width / 2;
        int y = (int)center.getY() - height / 2;
        return new BoundingBox(x, y, width, height);
    }

    private double getAspectRatio() {
        return this.getHeight() == 0 ? 0.0 : (double)this.getWidth() / (double)this.getHeight();
    }

    public String toString() {
        return "x: " + this.getX() + " y: " + this.getY() + " width: " + this.getWidth() + " height: " + this.getHeight();
    }

    public String fragment() {
        return "(" + this.getX() + "," + this.getY() + "," + this.getWidth() + "," + this.getHeight() + ")";
    }

    public void addBoundingbox(BoundingBox box) {
        this.m_left = Math.min(this.m_left, box.m_left);
        this.m_right = Math.max(this.m_right, box.m_right);
        this.m_top = Math.min(this.m_top, box.m_top);
        this.m_bottom = Math.max(this.m_bottom, box.m_bottom);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_bottom;
        result = 31 * result + this.m_left;
        result = 31 * result + this.m_right;
        result = 31 * result + this.m_top;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        if (this.m_bottom != other.m_bottom) {
            return false;
        }
        if (this.m_left != other.m_left) {
            return false;
        }
        if (this.m_right != other.m_right) {
            return false;
        }
        return this.m_top == other.m_top;
    }
}

