/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.browsers;

import com.vaadin.data.Container;
import com.vaadin.ui.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.SelectionNotifier;
import org.opennms.features.topology.api.TopologyServiceClient;
import org.opennms.features.topology.api.VerticesUpdateManager;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.OnmsVaadinContainer;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.osgi.EventConsumer;
import org.opennms.osgi.EventProxy;
import org.opennms.osgi.EventProxyAware;

public class SelectionAwareTable
extends Table
implements VerticesUpdateManager.VerticesUpdateListener,
EventProxyAware,
SelectionChangedListener,
GraphContainer.ChangeListener {
    private static final long serialVersionUID = 2761774077365441249L;
    private final OnmsVaadinContainer<?, ? extends Serializable> m_container;
    private final Set<SelectionNotifier> m_selectionNotifiers = new CopyOnWriteArraySet<SelectionNotifier>();
    private EventProxy eventProxy;
    private boolean m_disableRowCacheRefresh = false;

    public SelectionAwareTable(String caption, OnmsVaadinContainer container) {
        super(caption, (Container)container);
        this.m_container = container;
    }

    public void setColumnGenerators(Map generators) {
        for (Object key : generators.keySet()) {
            super.addGeneratedColumn(key, (Table.ColumnGenerator)generators.get(key));
            try {
                this.m_selectionNotifiers.add((SelectionNotifier)generators.get(key));
            }
            catch (ClassCastException classCastException) {}
        }
    }

    public void setCellStyleGenerator(Table.CellStyleGenerator generator) {
        super.setCellStyleGenerator(generator);
    }

    public String toString() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setNonCollapsibleColumns(List<String> nonCollapsibleColumns) {
        this.m_disableRowCacheRefresh = true;
        try {
            for (Object obj : this.m_container.getContainerPropertyIds()) {
                this.setColumnCollapsible(obj, true);
            }
            if (nonCollapsibleColumns == null) {
                nonCollapsibleColumns = new ArrayList<String>();
            }
            for (Object object : nonCollapsibleColumns) {
                this.setColumnCollapsible(object, false);
            }
        }
        finally {
            this.m_disableRowCacheRefresh = false;
        }
        this.refreshRowCache();
    }

    public void refreshRowCache() {
        if (this.m_disableRowCacheRefresh) {
            return;
        }
        super.refreshRowCache();
    }

    @Override
    @EventConsumer
    public void verticesUpdated(VerticesUpdateManager.VerticesUpdateEvent event) {
        if (this.isAttached()) {
            TopologyServiceClient source = event.getSource();
            if (event.getVertexRefs().isEmpty()) {
                this.selectionChanged(SelectionChangedListener.Selection.NONE);
            } else if (source.contributesTo(this.getContentType())) {
                SelectionChangedListener.Selection newSelection = source.getSelection(new ArrayList<VertexRef>(event.getVertexRefs()), this.getContentType());
                this.selectionChanged(newSelection);
            }
        }
    }

    @Override
    public void selectionChanged(SelectionChangedListener.Selection newSelection) {
        if (this.isAttached()) {
            this.m_container.selectionChanged(newSelection);
        }
    }

    public void resetPageBuffer() {
        if (this.m_container != null && this.m_container.getCache() != null && this.m_container.getPage() != null) {
            this.m_container.getCache().reload(this.m_container.getPage());
        }
        super.resetPageBuffer();
    }

    public void setEventProxy(EventProxy eventProxy) {
        this.eventProxy = eventProxy;
        for (Object eachPropertyId : this.getContainerPropertyIds()) {
            Table.ColumnGenerator columnGenerator = this.getColumnGenerator(eachPropertyId);
            if (columnGenerator == null || !EventProxyAware.class.isAssignableFrom(columnGenerator.getClass())) continue;
            ((EventProxyAware)columnGenerator).setEventProxy(eventProxy);
        }
    }

    @Override
    public void graphChanged(GraphContainer graphContainer) {
        if (this.isAttached()) {
            this.refreshRowCache();
        }
    }

    public ContentType getContentType() {
        if (this.m_container != null) {
            return this.m_container.getContentType();
        }
        return null;
    }

    protected EventProxy getEventProxy() {
        return Objects.requireNonNull(this.eventProxy, "EventProxy should not be null!");
    }
}

