/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.support.FocusStrategyImplementation;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.VertexRef;

public enum FocusStrategy {
    EMPTY((topologyProvider, arguments) -> Lists.newArrayList()),
    ALL((topologyProvider, arguments) -> topologyProvider.getVertices(new Criteria[0]).stream().map(VertexHopGraphProvider.DefaultVertexHopCriteria::new).collect(Collectors.toList())),
    FIRST((topologyProvider, arguments) -> {
        List collected = topologyProvider.getVertices(new Criteria[0]).stream().map(VertexHopGraphProvider.DefaultVertexHopCriteria::new).collect(Collectors.toList());
        if (!collected.isEmpty()) {
            return collected.subList(0, 1);
        }
        return Lists.newArrayList();
    }),
    SPECIFIC((topologyProvider, arguments) -> {
        Objects.requireNonNull(arguments);
        List collected = Arrays.stream(arguments).map(eachArgument -> new DefaultVertexRef(topologyProvider.getVertexNamespace(), (String)eachArgument)).map(eachVertexRef -> topologyProvider.getVertex((VertexRef)eachVertexRef, new Criteria[0])).filter(eachVertex -> eachVertex != null).map(VertexHopGraphProvider.DefaultVertexHopCriteria::new).collect(Collectors.toList());
        return collected;
    });

    private final FocusStrategyImplementation implementation;

    private FocusStrategy(FocusStrategyImplementation implementation) {
        this.implementation = implementation;
    }

    public List<VertexHopGraphProvider.VertexHopCriteria> getFocusCriteria(GraphProvider topologyProvider, String ... arguments) {
        return this.implementation.determine(topologyProvider, arguments);
    }

    public static FocusStrategy getStrategy(String input, FocusStrategy defaultValue) {
        for (FocusStrategy eachStrategy : FocusStrategy.values()) {
            if (!eachStrategy.name().equalsIgnoreCase(input)) continue;
            return eachStrategy;
        }
        return defaultValue;
    }
}

