/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.BeanItem;
import com.vaadin.data.util.HierarchicalContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.features.topology.api.support.HierarchicalBeanContainer;

public class FilterableHierarchicalContainer
extends HierarchicalContainer
implements Container.ItemSetChangeListener {
    HierarchicalBeanContainer<?, ?> m_container;
    List<Object> m_filteredItems;
    private List<Object> m_filteredRoots = null;
    private Map<Object, LinkedList<Object>> m_filteredChildren = null;
    private Map<Object, Object> m_filteredParent = null;
    private boolean m_includeParentsWhenFiltering = true;
    private Set<Object> m_filterOverride = null;
    private final Map<Object, Object> m_parent = new HashMap<Object, Object>();

    public FilterableHierarchicalContainer(HierarchicalBeanContainer<?, ?> container) {
        this.m_container = container;
        this.m_container.addItemSetChangeListener(this);
        this.m_container.addPropertySetChangeListener(new Container.PropertySetChangeListener(){

            public void containerPropertySetChange(Container.PropertySetChangeEvent event) {
                event.getContainer();
            }
        });
    }

    public BeanItem<?> getItem(Object itemId) {
        return this.m_container.getItem(itemId);
    }

    public Collection<String> getContainerPropertyIds() {
        return this.m_container.getContainerPropertyIds();
    }

    public List<?> getItemIds() {
        if (this.isFiltered()) {
            return this.m_filteredItems;
        }
        return this.m_container.getItemIds();
    }

    public Property<?> getContainerProperty(Object itemId, Object propertyId) {
        return this.m_container.getContainerProperty(itemId, propertyId);
    }

    public Class<?> getType(Object propertyId) {
        return this.m_container.getType(propertyId);
    }

    public int size() {
        return this.m_container.size();
    }

    public boolean containsId(Object itemId) {
        return this.m_container.containsId(itemId);
    }

    public Item addItem(Object itemId) throws UnsupportedOperationException {
        return null;
    }

    public Object addItem() throws UnsupportedOperationException {
        return null;
    }

    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        return false;
    }

    public boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        return false;
    }

    public boolean removeAllItems() throws UnsupportedOperationException {
        return false;
    }

    public Collection<?> getChildren(Object itemId) {
        if (this.m_filteredChildren != null) {
            LinkedList<Object> c = this.m_filteredChildren.get(itemId);
            if (c == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableCollection(c);
        }
        return this.m_container.getChildren(itemId);
    }

    public Object getParent(Object itemId) {
        if (this.m_filteredParent != null) {
            return this.m_filteredParent.get(itemId);
        }
        return this.m_container.getParent(itemId);
    }

    public Collection<?> rootItemIds() {
        if (this.m_filteredRoots != null) {
            return Collections.unmodifiableCollection(this.m_filteredRoots);
        }
        return this.m_container.rootItemIds();
    }

    public boolean setParent(Object itemId, Object newParentId) throws UnsupportedOperationException {
        return this.m_container.setParent(itemId, newParentId);
    }

    public boolean areChildrenAllowed(Object itemId) {
        return this.m_container.areChildrenAllowed(itemId);
    }

    public boolean setChildrenAllowed(Object itemId, boolean areChildrenAllowed) throws UnsupportedOperationException {
        return this.m_container.setChildrenAllowed(itemId, areChildrenAllowed);
    }

    public boolean isRoot(Object itemId) {
        if (this.m_filteredRoots != null) {
            // empty if block
        }
        return this.m_container.isRoot(itemId);
    }

    public boolean hasChildren(Object itemId) {
        if (this.m_filteredChildren != null) {
            return this.m_filteredChildren.containsKey(itemId);
        }
        return this.m_container.hasChildren(itemId);
    }

    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        return this.m_container.removeItem(itemId);
    }

    protected boolean doFilterContainer(boolean hasFilters) {
        if (!hasFilters) {
            this.m_filteredRoots = null;
            this.m_filteredChildren = null;
            this.m_filteredParent = null;
            if (this.getFilteredItemIds() != null) {
                boolean changed = this.m_container.getItemIds().size() != this.getFilteredItemIds().size();
                this.setFilteredItemIds(null);
                return changed;
            }
            return false;
        }
        this.m_filteredRoots = new LinkedList<Object>();
        this.m_filteredChildren = new HashMap<Object, LinkedList<Object>>();
        this.m_filteredParent = new HashMap<Object, Object>();
        if (this.m_includeParentsWhenFiltering) {
            HashSet<Object> includedItems = new HashSet<Object>();
            for (Object rootId : this.m_container.rootItemIds()) {
                if (!this.filterIncludingParents(rootId, includedItems)) continue;
                this.m_filteredRoots.add(rootId);
                this.addFilteredChildrenRecursively(rootId, includedItems);
            }
            this.m_filterOverride = includedItems;
            super.doFilterContainer(hasFilters);
            this.m_filterOverride = null;
            return true;
        }
        super.doFilterContainer(hasFilters);
        LinkedHashSet filteredItemIds = new LinkedHashSet(this.getItemIds());
        for (Object itemId : filteredItemIds) {
            Object itemParent = this.m_parent.get(itemId);
            if (itemParent == null || !filteredItemIds.contains(itemParent)) {
                this.m_filteredRoots.add(itemId);
                continue;
            }
            this.addFilteredChild(itemParent, itemId);
        }
        return true;
    }

    private void addFilteredChildrenRecursively(Object parentItemId, Set<Object> includedItems) {
        Collection childList = this.m_container.getChildren(parentItemId);
        if (childList == null) {
            return;
        }
        for (Object childItemId : childList) {
            if (!includedItems.contains(childItemId)) continue;
            this.addFilteredChild(parentItemId, childItemId);
            this.addFilteredChildrenRecursively(childItemId, includedItems);
        }
    }

    private void addFilteredChild(Object parentItemId, Object childItemId) {
        LinkedList<Object> parentToChildrenList = this.m_filteredChildren.get(parentItemId);
        if (parentToChildrenList == null) {
            parentToChildrenList = new LinkedList();
            this.m_filteredChildren.put(parentItemId, parentToChildrenList);
        }
        this.m_filteredParent.put(childItemId, parentItemId);
        parentToChildrenList.add(childItemId);
    }

    private boolean filterIncludingParents(Object itemId, Set<Object> includedItems) {
        boolean toBeIncluded = this.passesFilters(itemId);
        Collection childList = this.m_container.getChildren(itemId);
        if (childList != null) {
            for (Object childItemId : this.m_container.getChildren(itemId)) {
                toBeIncluded |= this.filterIncludingParents(childItemId, includedItems);
            }
        }
        if (toBeIncluded) {
            includedItems.add(itemId);
        }
        return toBeIncluded;
    }

    public void setFilteredItemIds(List<Object> itemIds) {
        this.m_filteredItems = itemIds;
    }

    public List<Object> getFilteredItemIds() {
        return this.m_filteredItems;
    }

    protected BeanItem<?> getUnfilteredItem(Object itemId) {
        return this.m_container.getItem(itemId);
    }

    public void containerItemSetChange(Container.ItemSetChangeEvent event) {
        this.fireItemSetChange();
    }

    public void fireItemUpdated() {
        this.m_container.fireItemSetChange();
    }
}

