/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.features.topology.api.topo.Ref;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.WrappedGroup;
import org.opennms.features.topology.api.topo.WrappedLeafVertex;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class WrappedVertex
implements VertexRef {
    public String iconKey;
    @XmlID
    public String id;
    public String ipAddr;
    public String label;
    @XmlTransient
    public String namespace;
    public Integer nodeID;
    public String styleName;
    public String tooltipText;
    public Integer x;
    public Integer y;
    @XmlTransient
    public boolean group;
    public boolean locked;
    public boolean selected;
    @XmlIDREF
    public WrappedVertex parent;

    public static WrappedVertex create(Vertex vertex) {
        return vertex.isGroup() ? new WrappedGroup(vertex) : new WrappedLeafVertex(vertex);
    }

    public WrappedVertex() {
    }

    protected WrappedVertex(VertexRef vertex) {
        if (vertex.getId() == null) {
            throw new IllegalArgumentException("Vertex has null ID: " + vertex);
        }
        if (vertex.getNamespace() == null) {
            throw new IllegalArgumentException("Vertex has null namespace: " + vertex);
        }
        this.id = vertex.getId();
        this.label = vertex.getLabel();
        this.namespace = vertex.getNamespace();
    }

    protected WrappedVertex(Vertex vertex) {
        this((VertexRef)vertex);
        this.iconKey = vertex.getIconKey();
        this.ipAddr = vertex.getIpAddress();
        this.nodeID = vertex.getNodeID();
        if (vertex.getParent() != null) {
            this.parent = new WrappedVertex(vertex.getParent());
        }
        this.styleName = vertex.getStyleName();
        this.tooltipText = vertex.getTooltipText();
        this.x = vertex.getX();
        this.y = vertex.getY();
        this.group = vertex.isGroup();
        this.locked = vertex.isLocked();
        this.selected = vertex.isSelected();
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        if (this.namespace == null) {
            try {
                BeanInfo info = Introspector.getBeanInfo(parent.getClass());
                for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                    if (!"namespace".equals(descriptor.getName())) continue;
                    this.namespace = (String)descriptor.getReadMethod().invoke(parent, new Object[0]);
                    LoggerFactory.getLogger(this.getClass()).debug("Setting namespace on {} to {} from parent", (Object)this, (Object)this.namespace);
                }
            }
            catch (IntrospectionException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Exception thrown when trying to fetch namespace from parent class " + parent.getClass(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Exception thrown when trying to fetch namespace from parent class " + parent.getClass(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Exception thrown when trying to fetch namespace from parent class " + parent.getClass(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Exception thrown when trying to fetch namespace from parent class " + parent.getClass(), (Throwable)e);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        result = 31 * result + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VertexRef)) {
            return false;
        }
        VertexRef ref = (VertexRef)obj;
        return this.getNamespace().equals(ref.getNamespace()) && this.getId().equals(ref.getId());
    }

    @Override
    public int compareTo(Ref o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.getNamespace().equals(o.getNamespace())) {
            if (this.getId().equals(o.getId())) {
                throw new IllegalStateException("equals() was inaccurate in " + this.getClass().getName());
            }
            return this.getId().compareTo(o.getId());
        }
        return this.getNamespace().compareTo(o.getNamespace());
    }

    public String toString() {
        return "WrappedVertex:" + this.namespace + ":" + this.id + "[label=" + this.label + ", styleName=" + this.styleName + "]";
    }
}

