/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.WrappedVertex;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="edge")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WrappedEdge {
    public String key;
    public String label;
    public String tooltipText;
    @XmlIDREF
    public WrappedVertex source;
    @XmlIDREF
    public WrappedVertex target;
    @XmlID
    public String id;
    @XmlTransient
    public String namespace;

    public WrappedEdge() {
    }

    public WrappedEdge(Edge edge, WrappedVertex source, WrappedVertex target) {
        this.key = edge.getKey();
        this.label = edge.getLabel();
        this.tooltipText = edge.getTooltipText();
        this.id = edge.getId();
        this.namespace = edge.getNamespace();
        this.source = source;
        this.target = target;
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        if (this.namespace == null) {
            try {
                BeanInfo info = Introspector.getBeanInfo(parent.getClass());
                for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                    if (!"namespace".equals(descriptor.getName())) continue;
                    this.namespace = (String)descriptor.getReadMethod().invoke(parent, new Object[0]);
                    LoggerFactory.getLogger(this.getClass()).debug("Setting namespace on {} to {} from parent", (Object)this, (Object)this.namespace);
                }
            }
            catch (IntrospectionException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Exception thrown when trying to fetch namespace from parent class " + parent.getClass(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Exception thrown when trying to fetch namespace from parent class " + parent.getClass(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Exception thrown when trying to fetch namespace from parent class " + parent.getClass(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Exception thrown when trying to fetch namespace from parent class " + parent.getClass(), (Throwable)e);
            }
        }
    }

    public String toString() {
        return "WrappedEdge:" + this.namespace + ":" + this.id + "[label=" + this.label + "]";
    }
}

