/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.browsers;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.vaadin.ui.Table;
import com.vaadin.ui.UI;
import java.util.Collection;
import java.util.HashSet;
import org.opennms.features.topology.api.VerticesUpdateManager;
import org.opennms.features.topology.api.WidgetContext;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.osgi.EventProxy;
import org.opennms.osgi.EventProxyAware;

public abstract class AbstractSelectionLinkGenerator
implements Table.ColumnGenerator,
EventProxyAware {
    private EventProxy m_eventProxy;

    protected void fireVertexUpdatedEvent(Collection<VertexRef> vertexRefs) {
        HashSet vertexRefSet = Sets.newHashSet(vertexRefs);
        this.getEventProxy().fireEvent((Object)new VerticesUpdateManager.VerticesUpdateEvent(vertexRefSet, this.getGraphProvider()));
    }

    protected void fireVertexUpdatedEvent(VertexRef vertexRef) {
        this.fireVertexUpdatedEvent(Lists.newArrayList((Object[])new VertexRef[]{vertexRef}));
    }

    private GraphProvider getGraphProvider() {
        UI ui = UI.getCurrent();
        if (ui instanceof WidgetContext) {
            return ((WidgetContext)ui).getGraphContainer().getBaseTopology();
        }
        return null;
    }

    public void setEventProxy(EventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }

    public EventProxy getEventProxy() {
        return this.m_eventProxy;
    }
}

