/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support.breadcrumbs;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.features.topology.api.Callbacks;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.support.VertexRefAdapter;
import org.opennms.features.topology.api.support.breadcrumbs.BreadcrumbCriteria;
import org.opennms.features.topology.api.support.breadcrumbs.ClickListener;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.VertexRef;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="breadcrumb")
public class Breadcrumb
implements ClickListener {
    @XmlElement(name="label")
    private String label;
    @XmlElement(name="target-namespace")
    private String targetNamespace;
    @XmlElement(name="source-vertex")
    @XmlJavaTypeAdapter(value=VertexRefAdapter.class)
    private VertexRef sourceVertex;

    protected Breadcrumb() {
    }

    public Breadcrumb(String label, String targetNamespace, VertexRef sourceVertex) {
        this.label = Objects.requireNonNull(label);
        this.targetNamespace = Objects.requireNonNull(targetNamespace);
        this.sourceVertex = sourceVertex;
    }

    public String getLabel() {
        return this.label;
    }

    public VertexRef getSourceVertex() {
        return this.sourceVertex;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Breadcrumb) {
            Breadcrumb other = (Breadcrumb)obj;
            boolean equals = Objects.equals(this.label, other.label) && Objects.equals(this.targetNamespace, other.targetNamespace) && Objects.equals(this.sourceVertex, other.sourceVertex);
            return equals;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.label, this.targetNamespace, this.sourceVertex);
    }

    @Override
    public void clicked(GraphContainer graphContainer) {
        if (!graphContainer.getBaseTopology().getVertexNamespace().equals(this.targetNamespace)) {
            this.navigateTo(graphContainer);
        }
    }

    public void navigateTo(GraphContainer graphContainer) {
        Objects.requireNonNull(graphContainer);
        GraphProvider targetGraphProvider = graphContainer.getMetaTopologyProvider().getGraphProviders().stream().filter(eachGraphProvider -> eachGraphProvider.getVertexNamespace().equals(this.getTargetNamespace())).findFirst().get();
        Breadcrumb.navigateTo(graphContainer, this, targetGraphProvider);
    }

    private static void navigateTo(GraphContainer graphContainer, Breadcrumb breadcrumb, GraphProvider targetGraphProvider) {
        BreadcrumbCriteria breadcrumbCriteria = Criteria.getSingleCriteriaForGraphContainer(graphContainer, BreadcrumbCriteria.class, true);
        if (breadcrumbCriteria.isEmpty()) {
            GraphProvider graphProvider = graphContainer.getBaseTopology();
            breadcrumbCriteria.setNewRoot(new Breadcrumb(graphProvider.getTopologyProviderInfo().getName(), graphProvider.getVertexNamespace(), null));
        }
        if (!graphContainer.getBaseTopology().getVertexNamespace().equals(targetGraphProvider.getVertexNamespace())) {
            graphContainer.selectTopologyProvider(targetGraphProvider, Callbacks.clearCriteria(), Callbacks.applyDefaultSemanticZoomLevel(), (theGraphContainer, theGraphProvider) -> theGraphContainer.addCriteria(breadcrumbCriteria));
        }
        breadcrumbCriteria.setNewRoot(breadcrumb);
        VertexRef sourceVertex = breadcrumb.getSourceVertex();
        if (sourceVertex != null) {
            Collection<VertexRef> oppositeVertices = graphContainer.getMetaTopologyProvider().getOppositeVertices(sourceVertex);
            String targetNamespace = targetGraphProvider.getVertexNamespace();
            List targetVertices = oppositeVertices.stream().filter(v -> v.getNamespace().matches(targetNamespace)).collect(Collectors.toList());
            targetVertices.stream().forEach(v -> graphContainer.addCriteria(new VertexHopGraphProvider.DefaultVertexHopCriteria((VertexRef)v)));
            if (targetVertices.isEmpty()) {
                Callbacks.applyDefaultCriteria().callback(graphContainer, targetGraphProvider);
            }
        } else {
            Callbacks.applyDefaultCriteria().callback(graphContainer, targetGraphProvider);
        }
        graphContainer.redoLayout();
    }
}

