/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support.breadcrumbs;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opennms.features.topology.api.support.breadcrumbs.Breadcrumb;
import org.opennms.features.topology.api.topo.Criteria;

public class BreadcrumbCriteria
extends Criteria {
    private List<Breadcrumb> breadcrumbs = Lists.newArrayList();

    public void setNewRoot(Breadcrumb breadcrumb) {
        if (this.breadcrumbs.contains(breadcrumb)) {
            int index = this.breadcrumbs.indexOf(breadcrumb);
            this.breadcrumbs = this.breadcrumbs.subList(0, index + 1);
        } else {
            this.breadcrumbs.add(breadcrumb);
        }
    }

    public void clear() {
        this.breadcrumbs.clear();
    }

    public List<Breadcrumb> getBreadcrumbs() {
        return Collections.unmodifiableList(this.breadcrumbs);
    }

    public boolean isEmpty() {
        return this.breadcrumbs.isEmpty();
    }

    @Override
    public Criteria.ElementType getType() {
        return Criteria.ElementType.GRAPH;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.breadcrumbs);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof BreadcrumbCriteria) {
            BreadcrumbCriteria other = (BreadcrumbCriteria)obj;
            boolean equals = Objects.equals(this.breadcrumbs, other.breadcrumbs);
            return equals;
        }
        return false;
    }
}

