/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.info;

import com.google.common.primitives.Doubles;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opennms.netmgt.measurements.api.MeasurementsService;
import org.opennms.netmgt.measurements.api.exceptions.MeasurementException;
import org.opennms.netmgt.measurements.model.Expression;
import org.opennms.netmgt.measurements.model.QueryRequest;
import org.opennms.netmgt.measurements.model.QueryResponse;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;

public class MeasurementsWrapper {
    private final MeasurementsService measurementsService;

    public MeasurementsWrapper(MeasurementsService measurementsService) {
        this.measurementsService = measurementsService;
    }

    public double getLastValue(String resource, String attribute) throws MeasurementException {
        return this.getLastValue(resource, attribute, "AVERAGE");
    }

    public double getLastValue(String resource, String attribute, String aggregation) throws MeasurementException {
        double[] values;
        long end = System.currentTimeMillis();
        long start = end - 900000L;
        QueryResponse response = this.queryInt(resource, attribute, start, end, 300000L, aggregation);
        if (response == null) {
            throw new RuntimeException(String.format("Failed to retrieve last value for attribute: '%s' on resource: '%s'. See logs for details.", attribute, resource));
        }
        QueryResponse.WrappedPrimitive[] columns = response.getColumns();
        if (columns.length > 0 && (values = columns[0].getList()).length > 0) {
            for (int i = values.length - 1; i >= 0; --i) {
                if (Double.isNaN(values[i])) continue;
                return values[i];
            }
        }
        return Double.NaN;
    }

    public List<Double> query(String resource, String attribute, long start, long end, long step, String aggregation) throws MeasurementException {
        QueryResponse.WrappedPrimitive[] columns = this.queryInt(resource, attribute, start, end, step, aggregation).getColumns();
        if (columns.length > 0) {
            return Doubles.asList((double[])columns[0].getList());
        }
        return Collections.emptyList();
    }

    public List<Double> computeUtilization(OnmsNode node, String ifName) throws MeasurementException {
        long end = System.currentTimeMillis();
        long start = end - 900000L;
        for (OnmsSnmpInterface snmpInterface : node.getSnmpInterfaces()) {
            if (!ifName.equals(snmpInterface.getIfName())) continue;
            String resourceId = "node[" + node.getId() + "].interfaceSnmp[" + snmpInterface.computeLabelForRRD() + "]";
            return this.computeUtilization(resourceId, start, end, 300000L, "AVERAGE");
        }
        return Arrays.asList(Double.NaN, Double.NaN);
    }

    public List<Double> computeUtilization(String resource, long start, long end, long step, String aggregation) throws MeasurementException {
        QueryRequest request = new QueryRequest();
        request.setRelaxed(true);
        request.setStart(start);
        request.setEnd(end);
        request.setStep(step);
        Source sourceIn = new Source();
        sourceIn.setAggregation(aggregation);
        sourceIn.setTransient(true);
        sourceIn.setAttribute("ifHCInOctets");
        sourceIn.setFallbackAttribute("ifInOctets");
        sourceIn.setResourceId(resource);
        sourceIn.setLabel("ifInOctets");
        Source sourceOut = new Source();
        sourceOut.setAggregation(aggregation);
        sourceOut.setTransient(true);
        sourceOut.setAttribute("ifHCOutOctets");
        sourceOut.setFallbackAttribute("ifOutOctets");
        sourceOut.setResourceId(resource);
        sourceOut.setLabel("ifOutOctets");
        request.setExpressions(Arrays.asList(new Expression("ifInPercent", "(8 * ifInOctects / 1000000) / ifInOctets.ifHighSpeed * 100", false), new Expression("ifOutPercent", "(8 * ifOutOctects / 1000000) / ifOutOctets.ifHighSpeed * 100", false)));
        request.setSources(Arrays.asList(sourceIn, sourceOut));
        QueryResponse.WrappedPrimitive[] columns = this.measurementsService.query(request).getColumns();
        double[] values1 = columns[0].getList();
        double[] values2 = columns[1].getList();
        for (int i = values1.length - 1; i >= 0; --i) {
            if (Double.isNaN(values1[i]) || Double.isNaN(values2[i])) continue;
            return Arrays.asList(values1[i], values2[i]);
        }
        return Arrays.asList(Double.NaN, Double.NaN);
    }

    public QueryResponse query(QueryRequest request) throws MeasurementException {
        return this.measurementsService.query(request);
    }

    private QueryResponse queryInt(String resource, String attribute, long start, long end, long step, String aggregation) throws MeasurementException {
        QueryRequest request = new QueryRequest();
        request.setRelaxed(false);
        request.setStart(start);
        request.setEnd(end);
        request.setStep(step);
        Source source = new Source();
        source.setAggregation(aggregation);
        source.setTransient(false);
        source.setAttribute(attribute);
        source.setResourceId(resource);
        source.setLabel(attribute);
        request.setSources(Collections.singletonList(source));
        return this.measurementsService.query(request);
    }
}

