/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.geo;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.base.Strings;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GeocoderConfig {
    private static final String URL_KEY = "gwt.openlayers.url";
    public static final String OPTIONS_KEY_PREFIX = "gwt.openlayers.options.";

    public static String getTileServerUrl() {
        String url = System.getProperty(URL_KEY);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0, (Object)"System Property 'gwt.openlayers.url' is not defined");
        return GeocoderConfig.sanitizeForVaadin(url);
    }

    public static Map<String, String> getOptions() {
        return System.getProperties().keySet().stream().filter(key -> ((String)key).startsWith(OPTIONS_KEY_PREFIX)).map(key -> ((String)key).substring(OPTIONS_KEY_PREFIX.length())).collect(Collectors.toMap(Function.identity(), key -> GeocoderConfig.sanitizeForVaadin(System.getProperty(OPTIONS_KEY_PREFIX + key))));
    }

    private static String sanitizeForVaadin(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return input;
        }
        return input.replaceAll("\\$\\{", "{");
    }
}

