/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api;

import java.util.List;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.topo.Criteria;

public abstract class Callbacks {
    private Callbacks() {
    }

    public static GraphContainer.Callback applyDefaultSemanticZoomLevel() {
        return (graphContainer, graphProvider) -> graphContainer.setSemanticZoomLevel(graphProvider.getDefaults().getSemanticZoomLevel());
    }

    public static GraphContainer.Callback clearCriteria() {
        return (graphContainer, graphProvider) -> graphContainer.clearCriteria();
    }

    public static GraphContainer.Callback applyDefaultCriteria() {
        return (graphContainer, graphProvider) -> {
            List<Criteria> defaultCriteriaList = graphProvider.getDefaults().getCriteria();
            if (defaultCriteriaList != null) {
                defaultCriteriaList.forEach(eachCriteria -> graphContainer.addCriteria((Criteria)eachCriteria));
            }
        };
    }

    public static GraphContainer.Callback redoLayout() {
        return (graphContainer, graphProvider) -> graphContainer.redoLayout();
    }

    public static GraphContainer.Callback applyDefaults() {
        return Callbacks.wrap(Callbacks.clearCriteria(), Callbacks.applyDefaultSemanticZoomLevel(), Callbacks.applyDefaultCriteria());
    }

    public static GraphContainer.Callback wrap(GraphContainer.Callback ... callbacks) {
        if (callbacks != null) {
            return (graphContainer, graphProvider) -> {
                for (GraphContainer.Callback eachCallback : callbacks) {
                    eachCallback.callback(graphContainer, graphProvider);
                }
            };
        }
        return (graphContainer, graphProvider) -> {};
    }
}

