/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.features.topology.api.BoundingBox;
import org.opennms.features.topology.api.Graph;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.HistoryOperation;
import org.opennms.features.topology.api.Layout;
import org.opennms.features.topology.api.Point;
import org.opennms.features.topology.api.support.BoundingBoxAdapter;
import org.opennms.features.topology.api.support.StringMapAdapter;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.support.VertexRefPointMapAdapter;
import org.opennms.features.topology.api.support.VertexRefSetAdapter;
import org.opennms.features.topology.api.topo.CollapsibleCriteria;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="saved-history")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SavedHistory {
    private static final Logger LOG = LoggerFactory.getLogger(SavedHistory.class);
    @XmlAttribute(name="semantic-zoom-level")
    private int m_szl;
    @XmlElement(name="bounding-box")
    @XmlJavaTypeAdapter(value=BoundingBoxAdapter.class)
    private BoundingBox m_boundBox;
    @XmlElement(name="locations")
    @XmlJavaTypeAdapter(value=VertexRefPointMapAdapter.class)
    private Map<VertexRef, Point> m_locations = new HashMap<VertexRef, Point>();
    @XmlElement(name="selection")
    @XmlJavaTypeAdapter(value=VertexRefSetAdapter.class)
    private Set<VertexRef> m_selectedVertices;
    @XmlElement(name="focus")
    @XmlJavaTypeAdapter(value=VertexRefSetAdapter.class)
    private Set<VertexRef> m_focusVertices;
    @XmlElement(name="settings")
    @XmlJavaTypeAdapter(value=StringMapAdapter.class)
    private final Map<String, String> m_settings = new HashMap<String, String>();

    protected SavedHistory() {
    }

    private static Set<VertexRef> getUnmodifiableSet(Collection<VertexRef> vertices) {
        HashSet<VertexRef> selectedVertices = new HashSet<VertexRef>();
        selectedVertices.addAll(vertices);
        return Collections.unmodifiableSet(selectedVertices);
    }

    private static Map<String, String> getOperationSettings(GraphContainer graphContainer, Collection<HistoryOperation> operations) {
        HashMap<String, String> retval = new HashMap<String, String>();
        for (HistoryOperation operation : operations) {
            retval.putAll(operation.createHistory(graphContainer));
        }
        return retval;
    }

    public SavedHistory(GraphContainer graphContainer, Collection<HistoryOperation> operations) {
        this(graphContainer.getSemanticZoomLevel(), graphContainer.getMapViewManager().getCurrentBoundingBox(), SavedHistory.saveLocations(graphContainer.getGraph()), SavedHistory.getUnmodifiableSet(graphContainer.getSelectionManager().getSelectedVertexRefs()), SavedHistory.getFocusVertices(graphContainer), SavedHistory.getOperationSettings(graphContainer, operations));
    }

    protected static Set<VertexRef> getFocusVertices(GraphContainer graphContainer) {
        Criteria[] criterias;
        HashSet<VertexRef> retVal = new HashSet<VertexRef>();
        for (Criteria crit : criterias = graphContainer.getCriteria()) {
            if (!(crit instanceof VertexHopGraphProvider.VertexHopCriteria) || crit instanceof CollapsibleCriteria) continue;
            retVal.addAll(((VertexHopGraphProvider.VertexHopCriteria)crit).getVertices());
        }
        return retVal;
    }

    SavedHistory(int szl, BoundingBox box, Map<VertexRef, Point> locations, Set<VertexRef> selectedVertices, Set<VertexRef> focusVertices, Map<String, String> operationSettings) {
        this.m_szl = szl;
        this.m_boundBox = box;
        this.m_locations = locations;
        this.m_selectedVertices = selectedVertices;
        this.m_focusVertices = focusVertices;
        this.m_settings.putAll(operationSettings);
        LOG.debug("Created " + this.toString());
    }

    private static Map<VertexRef, Point> saveLocations(Graph graph) {
        Collection<Vertex> vertices = graph.getDisplayVertices();
        HashMap<VertexRef, Point> locations = new HashMap<VertexRef, Point>();
        for (Vertex vert : vertices) {
            locations.put(vert, graph.getLayout().getLocation(vert));
        }
        return locations;
    }

    public int getSemanticZoomLevel() {
        return this.m_szl;
    }

    public BoundingBox getBoundingBox() {
        return this.m_boundBox;
    }

    public String getFragment() {
        StringBuffer retval = new StringBuffer().append("(").append(this.m_szl).append("),").append(this.m_boundBox.fragment()).append(",").append(this.m_boundBox.getCenter());
        CRC32 settingsCrc = new CRC32();
        for (Map.Entry<String, String> entry : this.m_settings.entrySet()) {
            try {
                settingsCrc.update(entry.getKey().getBytes("UTF-8"));
                settingsCrc.update(entry.getValue().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOG.error(unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
            }
        }
        retval.append(String.format(",(%X)", settingsCrc.getValue()));
        CRC32 locationsCrc = new CRC32();
        for (Map.Entry<VertexRef, Point> entry : this.m_locations.entrySet()) {
            try {
                locationsCrc.update(entry.getKey().getId().getBytes("UTF-8"));
                locationsCrc.update((int)entry.getValue().getX());
                locationsCrc.update((int)entry.getValue().getY());
            }
            catch (UnsupportedEncodingException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        retval.append(String.format(",(%X)", locationsCrc.getValue()));
        CRC32 cRC32 = new CRC32();
        for (VertexRef entry : this.m_selectedVertices) {
            try {
                cRC32.update(entry.getNamespace().getBytes("UTF-8"));
                cRC32.update(entry.getId().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        retval.append(String.format(",(%X)", cRC32.getValue()));
        CRC32 cRC322 = new CRC32();
        for (VertexRef entry : this.m_focusVertices) {
            try {
                cRC322.update(entry.getNamespace().getBytes("UTF-8"));
                cRC322.update(entry.getId().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        retval.append(String.format(",(%X)", cRC322.getValue()));
        return retval.toString();
    }

    public void apply(GraphContainer graphContainer, Collection<HistoryOperation> operations) {
        LOG.debug("Applying " + this.toString());
        for (HistoryOperation operation : operations) {
            try {
                operation.applyHistory(graphContainer, this.m_settings);
            }
            catch (Throwable e) {
                LOG.warn("Failed to perform applyHistory() operation", e);
            }
        }
        SavedHistory.applyVerticesInFocus(this.m_focusVertices, graphContainer);
        SavedHistory.applySavedLocations(this.m_locations, graphContainer.getGraph().getLayout());
        graphContainer.setSemanticZoomLevel(this.getSemanticZoomLevel());
        graphContainer.getSelectionManager().setSelectedVertexRefs(this.m_selectedVertices);
        graphContainer.getMapViewManager().setBoundingBox(this.getBoundingBox());
    }

    private static void applyVerticesInFocus(Set<VertexRef> focusVertices, GraphContainer graphContainer) {
        Set<VertexHopGraphProvider.VertexHopCriteria> vertexHopCriterias = Criteria.getCriteriaForGraphContainer(graphContainer, VertexHopGraphProvider.VertexHopCriteria.class);
        for (VertexHopGraphProvider.VertexHopCriteria eachCriteria : vertexHopCriterias) {
            graphContainer.removeCriteria(eachCriteria);
        }
        focusVertices.forEach(vertexRef -> graphContainer.addCriteria(new VertexHopGraphProvider.DefaultVertexHopCriteria((VertexRef)vertexRef)));
    }

    private static void applySavedLocations(Map<VertexRef, Point> locations, Layout layout) {
        for (VertexRef ref : locations.keySet()) {
            layout.setLocation(ref, locations.get(ref));
        }
    }

    public String toString() {
        StringBuffer retval = new StringBuffer().append(this.getClass().getSimpleName()).append(": ").append(this.getFragment()).append(": ");
        boolean first = true;
        for (Map.Entry<String, String> entry : this.m_settings.entrySet()) {
            if (first) {
                first = false;
            } else {
                retval.append(",");
            }
            retval.append(entry.getKey()).append("->").append(entry.getValue());
        }
        if (this.m_selectedVertices.size() > 0) {
            first = true;
            retval.append(",selectedVertices->{");
            for (VertexRef vertexRef : this.m_selectedVertices) {
                if (first) {
                    first = false;
                } else {
                    retval.append(",");
                }
                retval.append("[").append(vertexRef.getNamespace()).append(":").append(vertexRef.getId()).append("]");
            }
            retval.append("}");
        }
        if (this.m_focusVertices.size() > 0) {
            first = true;
            retval.append(",focusVertices->{");
            for (VertexRef vertexRef : this.m_focusVertices) {
                if (first) {
                    first = false;
                } else {
                    retval.append(",");
                }
                retval.append("[").append(vertexRef.getNamespace()).append(":").append(vertexRef.getId()).append("]");
            }
            retval.append("}");
        }
        return retval.toString();
    }
}

