/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.HistoryManager;
import org.opennms.features.topology.api.HistoryOperation;
import org.opennms.features.topology.api.support.SavedHistory;
import org.slf4j.LoggerFactory;

public abstract class AbstractHistoryManager
implements HistoryManager {
    private final List<HistoryOperation> m_operations = new CopyOnWriteArrayList<HistoryOperation>();

    @Override
    public List<HistoryOperation> getHistoryOperations() {
        return Collections.unmodifiableList(this.m_operations);
    }

    @Override
    public void applyHistory(String userId, String fragment, GraphContainer container) {
        SavedHistory hist = this.getHistory(userId, fragment);
        if (hist != null) {
            hist.apply(container, this.m_operations);
        }
    }

    @Override
    public String createHistory(String userId, GraphContainer graphContainer) {
        SavedHistory history = new SavedHistory(graphContainer, this.m_operations);
        this.saveHistory(userId, history);
        return history.getFragment();
    }

    protected abstract SavedHistory getHistory(String var1, String var2);

    protected abstract void saveHistory(String var1, SavedHistory var2);

    @Override
    public synchronized void onBind(HistoryOperation operation) {
        try {
            this.m_operations.add(operation);
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(this.getClass()).warn("Exception during onBind()", e);
        }
    }

    @Override
    public synchronized void onUnbind(HistoryOperation operation) {
        try {
            this.m_operations.remove(operation);
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(this.getClass()).warn("Exception during onUnbind()", e);
        }
    }
}

