/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo;

import org.opennms.features.topology.api.topo.VertexRef;

public class SearchResult {
    private final String m_id;
    private final String m_namespace;
    private final String m_label;
    private final String m_query;
    private boolean m_collapsible = false;
    private boolean m_collapsed = false;

    public SearchResult(String namespace, String id, String label, String query) {
        this.m_id = id;
        this.m_namespace = namespace;
        this.m_label = label;
        this.m_query = query;
    }

    public SearchResult(VertexRef vertexRef) {
        this(vertexRef.getNamespace(), vertexRef.getId(), vertexRef.getLabel(), null);
    }

    public SearchResult(SearchResult result) {
        this(result.getNamespace(), result.getId(), result.getLabel(), result.getQuery());
        this.setCollapsible(result.isCollapsible());
    }

    public final String getId() {
        return this.m_id;
    }

    public final String getNamespace() {
        return this.m_namespace;
    }

    public final String getLabel() {
        return this.m_label;
    }

    public final String getQuery() {
        return this.m_query;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        SearchResult ref = (SearchResult)obj;
        return this.getNamespace().equals(ref.getNamespace()) && this.getId().equals(ref.getId());
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        result = 31 * result + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        return result;
    }

    public String toString() {
        return "NameSpace:" + this.m_namespace + "; ID:" + this.m_id + "; Label:" + this.m_label;
    }

    public final boolean isCollapsible() {
        return this.m_collapsible;
    }

    public final void setCollapsible(boolean collapsible) {
        this.m_collapsible = collapsible;
    }

    public final boolean isCollapsed() {
        return this.m_collapsed;
    }

    public final void setCollapsed(boolean collapsed) {
        this.m_collapsed = collapsed;
    }
}

