/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.EdgeListener;
import org.opennms.features.topology.api.topo.EdgeProvider;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.slf4j.LoggerFactory;

public class SimpleEdgeProvider
implements EdgeProvider {
    private final String m_namespace;
    private final Map<String, Edge> m_edgeMap = new LinkedHashMap<String, Edge>();
    private final Set<EdgeListener> m_listeners = new CopyOnWriteArraySet<EdgeListener>();
    private final String m_contributesTo;

    public static Criteria labelMatches(String namespace, String regex) {
        return new MatchingCriteria(namespace, regex);
    }

    public SimpleEdgeProvider(String namespace, String contributesTo) {
        this.m_namespace = namespace;
        this.m_contributesTo = contributesTo;
    }

    public SimpleEdgeProvider(String namespace) {
        this(namespace, null);
    }

    @Override
    public String getEdgeNamespace() {
        return this.m_namespace;
    }

    @Override
    public boolean contributesTo(String namespace) {
        return this.m_contributesTo != null && this.m_contributesTo.equals(namespace);
    }

    private Edge getEdge(String id) {
        return this.m_edgeMap.get(id);
    }

    @Override
    public Edge getEdge(String namespace, String id) {
        return this.getEdge(id);
    }

    @Override
    public Edge getEdge(EdgeRef reference) {
        return this.getSimpleEdge(reference);
    }

    private Edge getSimpleEdge(EdgeRef reference) {
        if (this.getEdgeNamespace().equals(reference.getNamespace())) {
            if (reference instanceof Edge) {
                return (Edge)Edge.class.cast(reference);
            }
            return this.m_edgeMap.get(reference.getId());
        }
        return null;
    }

    @Override
    public List<Edge> getEdges(Collection<? extends EdgeRef> references) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (EdgeRef edgeRef : references) {
            Edge edge = this.getSimpleEdge(edgeRef);
            if (edgeRef == null) continue;
            edges.add(edge);
        }
        return Collections.unmodifiableList(edges);
    }

    private void fireEdgeSetChanged() {
        for (EdgeListener listener : this.m_listeners) {
            listener.edgeSetChanged(this, null, null, null);
        }
    }

    private void fireEdgesAdded(List<Edge> edges) {
        for (EdgeListener listener : this.m_listeners) {
            listener.edgeSetChanged(this, edges, null, null);
        }
    }

    private void fireEdgesRemoved(List<? extends EdgeRef> edges) {
        ArrayList<String> ids = new ArrayList<String>(edges.size());
        for (EdgeRef edgeRef : edges) {
            ids.add(edgeRef.getId());
        }
        for (EdgeListener edgeListener : this.m_listeners) {
            edgeListener.edgeSetChanged(this, null, null, ids);
        }
    }

    @Override
    public void addEdgeListener(EdgeListener edgeListener) {
        this.m_listeners.add(edgeListener);
    }

    @Override
    public void removeEdgeListener(EdgeListener edgeListener) {
        this.m_listeners.remove(edgeListener);
    }

    private void removeEdges(List<? extends EdgeRef> edges) {
        for (EdgeRef edgeRef : edges) {
            this.m_edgeMap.remove(edgeRef.getId());
        }
    }

    private void addEdges(List<Edge> edges) {
        for (Edge edge : edges) {
            if (edge.getNamespace() == null || edge.getId() == null) {
                LoggerFactory.getLogger(this.getClass()).warn("Discarding invalid edge: {}", (Object)edge);
                continue;
            }
            LoggerFactory.getLogger(this.getClass()).trace("Adding edge: {}", (Object)edge);
            this.m_edgeMap.put(edge.getId(), edge);
        }
    }

    public void setEdges(List<Edge> edges) {
        this.m_edgeMap.clear();
        this.addEdges(edges);
        this.fireEdgeSetChanged();
    }

    public void add(Edge ... edges) {
        this.add(Arrays.asList(edges));
    }

    public void add(List<Edge> edges) {
        this.addEdges(edges);
        this.fireEdgesAdded(edges);
    }

    public void remove(List<EdgeRef> edges) {
        this.removeEdges(edges);
        this.fireEdgesRemoved(edges);
    }

    public void remove(EdgeRef ... edges) {
        this.remove(Arrays.asList(edges));
    }

    @Override
    public List<Edge> getEdges(Criteria ... criteria) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : this.m_edgeMap.values()) {
            edges.add(edge.clone());
        }
        for (Criteria criterium : criteria) {
            try {
                MatchingCriteria matchingCriteria = (MatchingCriteria)criterium;
                Iterator itr = edges.iterator();
                while (itr.hasNext()) {
                    Edge next = (Edge)itr.next();
                    if (matchingCriteria.getType() != Criteria.ElementType.EDGE || matchingCriteria.getNamespace() != this.getEdgeNamespace() || matchingCriteria.matches(next)) continue;
                    itr.remove();
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return Collections.unmodifiableList(edges);
    }

    @Override
    public void clearEdges() {
        List<Edge> all = this.getEdges(new Criteria[0]);
        this.removeEdges(all);
        this.fireEdgesRemoved(all);
    }

    private static class MatchingCriteria
    extends Criteria {
        private String m_namespace;
        private String m_regex;

        public MatchingCriteria(String namespace, String regex) {
            this.m_namespace = namespace;
            this.m_regex = regex;
        }

        @Override
        public Criteria.ElementType getType() {
            return Criteria.ElementType.EDGE;
        }

        @Override
        public String getNamespace() {
            return this.m_namespace;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.m_namespace, this.m_regex);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (obj instanceof MatchingCriteria) {
                MatchingCriteria c = (MatchingCriteria)obj;
                boolean equals = Objects.equals(c.m_namespace, this.m_namespace) && Objects.equals(c.m_regex, this.m_regex);
                return equals;
            }
            return false;
        }

        public boolean matches(Edge edge) {
            return edge.getLabel().matches(this.m_regex);
        }
    }
}

