/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support;

import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.VertexRef;

public class VertexRefSetAdapter
extends XmlAdapter<VertexRefSet, Set<VertexRef>> {
    public VertexRefSet marshal(Set<VertexRef> v) throws Exception {
        if (v == null) {
            return null;
        }
        VertexRefSet retval = new VertexRefSet();
        for (VertexRef key : v) {
            VertexRefEntry entry = new VertexRefEntry();
            entry.namespace = key.getNamespace();
            entry.id = key.getId();
            entry.label = key.getLabel();
            retval.entry.add(entry);
        }
        return retval;
    }

    public Set<VertexRef> unmarshal(VertexRefSet v) throws Exception {
        if (v == null) {
            return null;
        }
        HashSet<VertexRef> retval = new HashSet<VertexRef>();
        for (VertexRefEntry entry : v.entry) {
            DefaultVertexRef ref = new DefaultVertexRef(entry.namespace, entry.id, entry.label);
            retval.add(ref);
        }
        return retval;
    }

    public static final class VertexRefEntry {
        @XmlAttribute
        public String namespace;
        @XmlAttribute
        public String id;
        @XmlAttribute
        public String label;
    }

    public static final class VertexRefSet {
        public Set<VertexRefEntry> entry = new HashSet<VertexRefEntry>(0);
    }
}

