/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api;

import com.vaadin.server.Page;
import com.vaadin.server.VaadinServlet;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.opennms.features.topology.api.Operation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperation
implements Operation {
    @Override
    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        return true;
    }

    @Override
    public boolean enabled(List<VertexRef> targets, OperationContext operationContext) {
        if (targets == null || targets.size() < 2) {
            for (VertexRef target : targets) {
                Integer nodeValue = AbstractOperation.getNodeIdValue(operationContext, target);
                if (nodeValue == null || nodeValue <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getId() {
        return this.getClass().getSimpleName();
    }

    protected static String getLabelValue(OperationContext operationContext, VertexRef target) {
        Vertex vertex = AbstractOperation.getVertexItem(operationContext, target);
        return vertex == null ? null : vertex.getLabel();
    }

    protected static String getIpAddrValue(OperationContext operationContext, VertexRef target) {
        Vertex vertex = AbstractOperation.getVertexItem(operationContext, target);
        return vertex == null ? null : vertex.getIpAddress();
    }

    protected static Integer getNodeIdValue(OperationContext operationContext, VertexRef target) {
        Vertex vertex = AbstractOperation.getVertexItem(operationContext, target);
        return vertex == null ? null : vertex.getNodeID();
    }

    protected static Vertex getVertexItem(OperationContext operationContext, VertexRef target) {
        Vertex vertex = operationContext.getGraphContainer().getBaseTopology().getVertex(target, operationContext.getGraphContainer().getCriteria());
        if (vertex == null) {
            LoggerFactory.getLogger(AbstractOperation.class).debug("Null vertex found for vertex reference: {}:{}", (Object)target.getNamespace(), (Object)target.getId());
            return null;
        }
        return vertex;
    }

    protected String getFullUrl(String urlFragment) {
        URI currentLocation = Page.getCurrent().getLocation();
        String contextRoot = VaadinServlet.getCurrent().getServletContext().getContextPath();
        try {
            return new URL(currentLocation.toURL(), contextRoot + "/" + urlFragment).toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to create full URL from current location: " + currentLocation + ", context root: " + contextRoot + ", url: " + urlFragment);
        }
    }
}

